<!DOCTYPE html>
<html>

<head>
    <title>Deal Detail</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
        }

        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .badge-danger {
            background: rgb(219, 14, 14);
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
        }

        .badge-success {
            background: rgb(2, 117, 40);
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
        }

        .box {
            border: 1px solid #ddd;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 6px;
        }

        .section-title {
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            padding: 8px;
            text-align: right;
        }

        th {
            text-align: left;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
        }

        .logo {
            display: flex;
            justify-content: end;
            text-align: right;
        }
    </style>
</head>

<body>

    <div class="header">
        <div class="logo">
            <img src="{{ public_path('admin-assets/img/logo.png') }}" alt="">
        </div>
        <div>
            <h2>@lang('message.deal') #{{ $deal_data->deal_number }}
                @if ($deal_data->deal_status == COMPLETED)
                    <span class="badge-success">{{ ucwords(str_replace('_', ' ', $deal_data->deal_status)) }}</span>
                @else
                    <span class="badge-danger">{{ ucwords(str_replace('_', ' ', $deal_data->deal_status)) }}</span>
                @endif


            </h2>
            <span><strong>{{ ucfirst($deal_data->deal_title) }}</strong></span>

            <p><strong>@lang('message.customer_list_name') : </strong>{{ ucfirst($deal_data->second_party->second_party_name) }}</p>
            <p><strong>@lang('message.customer_list_mobile'):
                </strong>{{ $deal_data->second_party->second_party_dial_code }}&nbsp;{{ $deal_data->second_party->second_party_mobile_number }}
            </p>
            @if ($deal_data->second_party->second_party_address)
                <p><strong>@lang('message.address') : </strong> {{ $deal_data->second_party->second_party_address }}
            @endif
            <br>
            @if ($deal_data->second_party->cityName)
                {{ $deal_data->second_party->cityName }},&nbsp;
            @endif
            @if ($deal_data->second_party->second_party_state)
                {{ $deal_data->second_party->second_party_state }},&nbsp;
            @endif
            @if ($deal_data->second_party->second_party_country)
                {{ $deal_data->second_party->second_party_country }},&nbsp;
            @endif
            </p>


        </div>

    </div>




    <div class="box">
        <p class="section-title">@lang('message.date_time')</p>
        <p>{{ $deal_data->deal_created_date }} at {{ $deal_data->deal_created_time }}</p>
    </div>

    <div class="box">
        <p class="section-title">@lang('message.payment_details')</p>
        @if ($deal_data->customer_type == BUYER)
            <table>
                <tr>
                    <th>@lang('message.item_price')</th>
                    <td>${{ $deal_data->deal_amount }}</td>
                </tr>

                <tr>
                    <th>@lang('message.commission') %</th>
                    <td>${{ $deal_data->commission_amount }}</td>

                </tr>


                <tr>
                    <th>@lang('message.total_amount_paid')</th>
                    <td><strong>${{ $deal_data->total_deal_amount }}</strong></td>
                </tr>
            </table>
        @elseif($deal_data->customer_type == SELLER)
            <table>
                <tr>
                    <th>@lang('message.item_price')</th>
                    <td>${{ $deal_data->deal_amount }}</td>
                </tr>


                <tr>
                    <th>@lang('message.received_amount')</th>
                    <td><strong>${{ $deal_data->deal_amount }}</strong></td>
                </tr>
            </table>
        @endif
    </div>

    <div class="footer">
        @lang('message.thank_you')
    </div>

</body>

</html>
