<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default"
    data-assets-path="../assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Dashboard</title>
    <meta name="description" content="" />
    <meta name="my-route" content="{!! route('admin.deals.count') !!}">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('admin-assets/img/favicon/favicon.png') }}" />
    <!-- Fonts -->

    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />
    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{ asset('admin-assets/vendor/fonts/boxicons.css') }}" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('admin-assets/vendor/css/core.css') }}"
        class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('admin-assets/vendor/css/theme-default.css') }}"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('admin-assets/css/demo.css') }}" />
    {{-- custom css --}}
    <link rel="stylesheet" href="{{ asset('admin-assets/css/custom.css') }}" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('admin-assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin-assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin-assets/css/loader.css') }}" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="{{ asset('admin-assets/vendor/js/helpers.js') }}"></script>

    <script src="{{ asset('admin-assets/js/config.js') }}"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/2.2.1/css/dataTables.dataTables.css" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <link rel="stylesheet" href="//cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="//cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
    <style>
        .iti {
            display: block !important;
        }
    </style>
</head>

<body>
    <div class="overlay" id="loader" style="display: none;">
        <div class="loader"></div>
    </div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand justify-content-center">
                    <div class="logo-img text-center">
                        <a href="{{ route('admin.dashboard') }}" class="app-brand-link">
                            <span class="app-brand-logo demo">
                                <img class="img-fluid logo-size" src="{{ asset(LOGO_IMG_PATH) }}" alt="">
                            </span>
                            {{-- <div> <span class="app-brand-text demo menu-text fw-bolder ms-2">@lang('message.app_name')</span></div> --}}

                        </a>
                    </div>
                    {{-- <a href="{{ route('admin.dashboard') }}" class="app-brand-link">
                        <span class="app-brand-logo demo">
                            <img class="img-fluid logo-size" src="{{ asset('admin-assets/img/logo.png') }}"
                                alt="">
                        </span>
                        <div> <span class="app-brand-text demo menu-text fw-bolder ms-2">@lang('message.app_name')</span></div>

                    </a> --}}




                    <a href="javascript:void(0);"
                        class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
                        <i class="bx bx-chevron-left bx-sm align-middle"></i>
                    </a>
                </div>
                <div class="menu-inner-shadow"></div>
                <ul class="menu-inner py-1">
                    <!-- Dashboard -->

                    <li class="menu-item {{ setActive('admin.dashboard') }}">
                        <a href="{{ route('admin.dashboard') }}" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-home-circle"></i>
                            <div data-i18n="Analytics">@lang('message.dashboard')</div>
                            {{-- 
                        <div data-i18n="Analytics">@lang('auth.failed')</div>
                        --}}
                        </a>
                    </li>


                    <!-- Cards -->

                    @if (
                        $authUser->hasPermissionTo('list - customer') ||
                            $authUser->hasPermissionTo('edit - customer') ||
                            $authUser->hasPermissionTo('delete - customer') ||
                            $authUser->hasPermissionTo('list - customer rank') ||
                            $authUser->hasPermissionTo('edit - customer rank') ||
                            $authUser->id == 1)
                        <li
                            class="menu-item {{ Route::is('admin.customer.*', 'admin.customerRank.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon bx bx-user"></i>
                                <div data-i18n="Layouts">@lang('message.customer_management')</div>
                            </a>

                            <ul class="menu-sub">
                                @if (
                                    $authUser->hasPermissionTo('edit - customer') ||
                                        $authUser->hasPermissionTo('delete - customer') ||
                                        $authUser->hasPermissionTo('list - customer') ||
                                        $authUser->id == 1)
                                    <li
                                        class="menu-item {{ setActive(['admin.customer.index', 'admin.customer.edit']) }}">
                                        <a href="{{ route('admin.customer.index') }}" class="menu-link">

                                            <div data-i18n="Basic">@lang('message.customer')</div>
                                        </a>
                                    </li>
                                @endif
                                @if (
                                    $authUser->hasPermissionTo('edit - customer rank') ||
                                        $authUser->hasPermissionTo('list - customer rank') ||
                                        $authUser->id == 1)
                                    <li
                                        class="menu-item {{ setActive(['admin.customerRank.index', 'admin.customerRank.edit']) }}">
                                        <a href="{{ route('admin.customerRank.index') }}" class="menu-link">
                                            <div data-i18n="Without menu">@lang('message.customer_ranks')</div>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </li>

                    @endif




                    @if ($authUser->hasPermissionTo('list - ongoing deals') || $authUser->id == 1)
                        <!-- Cards -->
                        <li class="menu-item {{ setActive('admin.deals.ongoing') }}">
                            <a href="{{ route('admin.deals.ongoing') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bxs-badge-dollar"></i>
                                <div data-i18n="Basic">@lang('message.ongoing_deals')</div>
                            </a>
                        </li>
                    @endif

                    @if ($authUser->hasPermissionTo('list - hold amount deals') || $authUser->id == 1)
                        <li class="menu-item {{ setActive('admin.deals.holdAmount') }}">
                            <a href="{{ route('admin.deals.holdAmount') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bxs-offer"></i>
                                <div data-i18n="Basic">@lang('message.hold_amount_deals')</div>
                                <span id="recent-hold-deals-badge" class="count-menu">0</span>
                            </a>
                        </li>
                    @endif

                    @if ($authUser->hasPermissionTo('list - dispute deals') || $authUser->id == 1)
                        <li class="menu-item {{ setActive('admin.deals.disputed') }}">
                            <a href="{{ route('admin.deals.disputed') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bxs-error-alt"></i>
                                <div data-i18n="Basic">@lang('message.disputed_deals')</div>
                                <span id="recent-disputed-deals-badge" class="count-menu">0</span>
                            </a>
                        </li>
                    @endif
                    @if ($authUser->hasPermissionTo('list - Cancelled Deals') || $authUser->id == 1)
                        <li class="menu-item {{ setActive('admin.deals.cancelled') }}">
                            <a href="{{ route('admin.deals.cancelled') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bxs-x-circle"></i>
                                <div data-i18n="Basic">@lang('message.cancel_deals')</div>
                                <span id="recent-canceled-deals-badge" class="count-menu ">0</span>
                            </a>
                        </li>
                    @endif
                    @if ($authUser->hasPermissionTo('list - closed deals') || $authUser->id == 1)
                        <li class="menu-item {{ setActive('admin.deals.closed') }}">
                            <a href="{{ route('admin.deals.closed') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bxs-lock-alt"></i>
                                <div data-i18n="Basic">@lang('message.closed_deals')</div>


                            </a>
                        </li>
                    @endif
                    @if ($authUser->hasPermissionTo('list - Declined deals') || $authUser->id == 1)
                        <li class="menu-item {{ setActive('admin.deals.declined') }}">
                            <a href="{{ route('admin.deals.declined') }}" class="menu-link">
                                <i class="menu-icon tf-icons bx bx-block"></i>
                                <div data-i18n="Basic">@lang('message.declined_deals')</div>


                            </a>
                        </li>
                    @endif
                    {{-- @if ($authUser->hasPermissionTo('About Us') || $authUser->hasPermissionTo('Help') || $authUser->hasPermissionTo('Terms and Conditions') || $authUser->hasPermissionTo('Privacy Policy') || $authUser->id == 1)
                        <!-- Layouts -->

                         <li
                            class="menu-item {{ Route::is('admin.setting.aboutUs', 'admin.setting.help', 'admin.setting.privacyPolicy', 'admin.setting.termsAndConditions') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons bx bx-layout"></i>
                                <div data-i18n="Layouts">@lang('message.page_management')</div>
                            </a>

                            <ul class="menu-sub">
                                @if ($authUser->hasPermissionTo('About Us') || $authUser->id == 1)
                                    <li class="menu-item {{ setActive('admin.setting.aboutUs') }}">
                                        <a href="{{ route('admin.setting.aboutUs') }}" class="menu-link">
                                            <div data-i18n="Without menu">@lang('message.about_us')</div>
                                        </a>
                                    </li>
                                @endif
                                @if ($authUser->hasPermissionTo('Help') || $authUser->id == 1)
                                    <li class="menu-item {{ setActive('admin.setting.help') }}">
                                        <a href="{{ route('admin.setting.help') }}" class="menu-link">
                                            <div data-i18n="Without navbar">@lang('message.help')</div>
                                        </a>
                                    </li>
                                @endif
                                @if ($authUser->hasPermissionTo('Terms and Conditions') || $authUser->id == 1)
                                    <li class="menu-item {{ setActive('admin.setting.termsAndConditions') }}">
                                        <a href="{{ route('admin.setting.termsAndConditions') }}" class="menu-link">
                                            <div data-i18n="Container">@lang('message.terms_conditions')</div>
                                        </a>
                                    </li>
                                @endif
                                @if ($authUser->hasPermissionTo('Privacy Policy') || $authUser->id == 1)
                                    <li class="menu-item {{ setActive('admin.setting.privacyPolicy') }}">

                                        <a href="{{ route('admin.setting.privacyPolicy') }}" class="menu-link">
                                            <div data-i18n="Fluid">@lang('message.privacy_policy')</div>
                                        </a>

                                        </span>
                                    </li>
                                @endif

                            </ul>
                        </li> 
                    @endif --}}
                    @if (
                        $authUser->hasPermissionTo('add - banner') ||
                            $authUser->hasPermissionTo('list - banner') ||
                            $authUser->hasPermissionTo('edit - banner') ||
                            $authUser->hasPermissionTo('delete - banner') ||
                            $authUser->id == 1)
                        <li class="menu-item {{ Route::is('admin.banner.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons bx bxs-image"></i>
                                <div data-i18n="Layouts">@lang('message.banners')</div>
                            </a>

                            <ul class="menu-sub">
                                @if ($authUser->hasPermissionTo('add - banner') || $authUser->id == 1)
                                    <li class="menu-item {{ setActive('admin.banner.create') }}">
                                        <a href="{{ route('admin.banner.create') }}" class="menu-link">
                                            <div data-i18n="Without menu">@lang('message.add_banner')</div>
                                        </a>
                                    </li>
                                @endif
                                @if (
                                    $authUser->hasPermissionTo('list - banner') ||
                                        $authUser->hasPermissionTo('edit - banner') ||
                                        $authUser->hasPermissionTo('delete - banner') ||
                                        $authUser->id == 1)
                                    <li
                                        class="menu-item {{ setActive(['admin.banner.edit', 'admin.banner.index']) }}">
                                        <a href="{{ route('admin.banner.index') }}" class="menu-link">
                                            <div data-i18n="Without navbar">@lang('message.view_banner')</div>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </li>
                    @endif
                    @if ($authUser->id == 1)
                        <li class="menu-item {{ Route::is('admin.role.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons bx bx-shield"></i>
                                <div data-i18n="Layouts">@lang('message.roles')</div>
                            </a>

                            <ul class="menu-sub">
                                <li class="menu-item {{ setActive('admin.role.create') }}">
                                    <a href="{{ route('admin.role.create') }}" class="menu-link">
                                        <div data-i18n="Without menu">@lang('message.add_roles')</div>
                                    </a>
                                </li>
                                <li class="menu-item {{ setActive(['admin.role.edit', 'admin.role.index']) }}">
                                    <a href="{{ route('admin.role.index') }}" class="menu-link">
                                        <div data-i18n="Without navbar">@lang('message.view_roles')</div>
                                    </a>
                                </li>


                            </ul>
                        </li>
                    @endif
                    @if ($authUser->id == 1)
                        <li class="menu-item {{ Route::is('admin.user.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons bx bx-user"></i>
                                <div data-i18n="Layouts">@lang('message.users')</div>
                            </a>

                            <ul class="menu-sub">
                                <li class="menu-item {{ setActive('admin.user.create') }}">
                                    <a href="{{ route('admin.user.create') }}" class="menu-link">
                                        <div data-i18n="Without menu">@lang('message.add_user')</div>
                                    </a>
                                </li>
                                <li class="menu-item {{ setActive(['admin.user.edit', 'admin.user.index']) }}">
                                    <a href="{{ route('admin.user.index') }}" class="menu-link">
                                        <div data-i18n="Without navbar">@lang('message.view_user')</div>
                                    </a>
                                </li>


                            </ul>
                        </li>
                    @endif
                </ul>
            </aside>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">





                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="bx bx-menu bx-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <!-- Search -->
                        <h6 class="text-dark welcome-title">
                            @lang('message.welcome_to') <span class="text-capitalize">{{ $currentRole }}</span>
                            @lang('message.panel')
                        </h6>

                        <!-- /Search -->
                        <ul class="navbar-nav flex-row align-items-center ms-auto">
                            @php
                                $currentLocale = session('admin_locale', 'en'); // default set
                                $languages = ['en' => 'EN', 'es' => 'ES']; // i can add more languages here

                            @endphp
                            @if ($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1)
                                @if (isset($data['export_option']))
                                    <li class="px-2">
                                        <form id="exportExcel" action="{{ route('admin.earnings.exportReport') }}"
                                            method="post">
                                            @csrf
                                            <input type="hidden" name="selected_year" id="selectedYear"
                                                value="{{ $data['selectedYear'] }}">
                                            <button class="excel-btn" type="button" id="exportBtn"
                                                title="Export Report">
                                                <img title="Export Report" width="30"
                                                    src="{{ asset('admin-assets/img/icons/download-excel-file.png') }}"
                                                    alt="Export Report">
                                            </button>
                                        </form>

                                    </li>
                                @endif
                            @endif
                            @if ($authUser->hasPermissionTo('list - ongoing deals') || $authUser->id == 1)
                                <!-- Cards -->

                                <li class="paymentNotification-dropdown paymntnotification">
                                    <i class='bx bxs-bell notification-bell'></i>
                                    @if ($paymentNotificationCount > 0)
                                        <span class="notification-count">{{ $paymentNotificationCount }}</span>
                                    @endif
                                    <div class="paymentNotifications-list payemnt-notifications-list">
                                        <ul id="notification-list">
                                            @if ($paymentNotificationCount === 0)
                                                <li class="no-notification">@lang('message.no_new_notification')</li>
                                            @else
                                                @foreach ($paymentProofNotifications as $payprnotification)
                                                    <li class="no-notification">
                                                        <a
                                                            href="{{ route('admin.deal.show', $payprnotification->deal_id) }}">
                                                            {{ app()->getLocale() === 'en' ? $payprnotification->message : $payprnotification->message_es }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </ul>
                                    </div>
                                </li>
                            @endif
                            @if ($authUser->hasPermissionTo('conversation - dispute deals') || $authUser->id == 1)
                                <li class="size-email notification-dropdown">
                                    <i class='bx bxs-envelope'></i>
                                    @if ($unreadCount > 0)
                                        <span class="message-count">{{ $unreadCount }}</span>
                                    @endif

                                    <div class="notifications-list">
                                        <ul id="messages-list">
                                            @if ($unreadCount === 0)
                                                <li class="no-messages">@lang('message.no_new_messages')</li>
                                            @else
                                                @foreach ($notifications as $notification)
                                                    <li class="no-messages">
                                                        <a
                                                            href="{{ route('admin.deal.show', $notification->deal_id) }}">
                                                            {{ app()->getLocale() === 'en' ? $notification->message : $notification->message_es }}
                                                    </li>
                                                    </a>
                                                @endforeach
                                            @endif
                                        </ul>
                                    </div>
                                </li>
                            @endif
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown"
                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    {{ $languages[$currentLocale] }} <!-- Show selected language -->
                                </a>

                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                    @foreach ($languages as $key => $lang)
                                        @if ($key !== $currentLocale)
                                            <!-- Hide selected language -->
                                            <li>
                                                <form action="{{ route('switchLang') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="locale"
                                                        value="{{ $key }}">
                                                    <button class="dropdown-item"
                                                        type="submit">{{ $lang }}</button>
                                                </form>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </li>

                            <!-- User -->
                            <li class="nav-item navbar-dropdown dropdown-user dropdown">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);"
                                    data-bs-toggle="dropdown">
                                    <div class="avatar avatar-online">
                                        <img width='100' src="{{ asset('uploads/admin/' . Auth::user()->image) }}"
                                            alt class="w-px-40 h-auto rounded-circle" />
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0 me-3">
                                                    <div class="avatar ">
                                                        <img width='100'
                                                            src="{{ asset('uploads/admin/' . Auth::user()->image) }}"
                                                            alt class="w-px-40 h-auto rounded-circle" />

                                                    </div>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <span
                                                        class="fw-semibold d-block text-capitalize">{{ Auth::user()->name }}</span>
                                                    <small class="text-muted">{{ Auth::user()->email }}</small>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    {{-- <li>
                                        <div class="dropdown-divider"></div>
                                    </li> --}}
                                    @if ($authUser->hasPermissionTo('update profile - setting') || $authUser->id == 1)
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.profile') }}">
                                                <i class="bx bx-user me-2"></i>
                                                <span class="align-middle">@lang('message.my_profile')</span>
                                            </a>
                                        </li>
                                    @endif
                                    @if ($authUser->hasPermissionTo('change password - setting') || $authUser->id == 1)
                                        <li>
                                            <a class="dropdown-item"
                                                href="{{ route('admin.profile.changePassword') }}">
                                                <i class='bx bx-lock me-2'></i>
                                                <span class="align-middle">@lang('message.change_password')</span>
                                            </a>
                                        </li>
                                    @endif
                                    @if ($authUser->hasPermissionTo('deal - setting') || $authUser->id == 1)
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.setting') }}">
                                                <i class="bx bx-cog me-2"></i>
                                                <span class="align-middle">@lang('message.deal_settings')</span>
                                            </a>
                                        </li>


                                        {{-- <li>
                                        <a class="dropdown-item" href="#">
                                            <span class="d-flex align-items-center align-middle">
                                                <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                                                <span class="flex-grow-1 align-middle">Billing</span>
                                                <span
                                                    class="flex-shrink-0 badge badge-center rounded-pill bg-danger w-px-20 h-px-20">4</span>
                                            </span>
                                        </a>
                                    </li> --}}
                                    @endif
                                    @if ($authUser->hasPermissionTo('details manage - bank') || $authUser->id == 1)
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.setting.bankDetails') }}">
                                                <i class="bx bx-wallet me-2"></i>
                                                <span class="align-middle">@lang('message.bank_details')</span>
                                            </a>
                                        </li>
                                    @endif
                                    {{-- <li>
                                        <div class="dropdown-divider"></div>
                                    </li> --}}
                                    <li>
                                        <form id="logout-form" action="{{ route('admin.logout') }}" method="POST"
                                            style="display:none;">
                                            @csrf
                                        </form>
                                        <a class="dropdown-item" href="#logout-form"
                                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                            <i class="bx bx-power-off me-2"></i>
                                            <span class="align-middle">@lang('message.log_out')</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ User -->
                        </ul>
                    </div>
                </nav>
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    @yield('content')
                </div>

                <!-- Content wrapper -->
                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl d-flex flex-wrap justify-content-end py-2 flex-md-row flex-column">
                        <div class="mb-2 mb-md-0">
                            © {{ date('Y') }}


                            <a href="https://intellisense.ca/" target="_blank"
                                class="footer-link fw-bolder">Intellisense
                                Technology</a>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
        </div>
        <!-- / Layout page -->
    </div>
    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('admin-assets/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->
    <!-- Vendors JS -->
    <script src="{{ asset('admin-assets/vendor/libs/apex-charts/apexcharts.js') }}"></script>
    <!-- Main JS -->
    <script src="{{ asset('admin-assets/js/main.js') }}"></script>

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdn.datatables.net/2.2.1/js/dataTables.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    @yield('top_scripts')

    <script src="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="//cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="//cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="//cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script src="{{ asset('admin-assets/js/script.js') }}"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ckeditor/4.22.1/ckeditor.js"></script>
    @yield('scripts');
    <script>
        window.translation = {
            areYouSure: "{{ __('message.are_you_sure') }}",
            deleteWarning: "{{ __('message.confirm_delete_warning') }}",
            yesDelete: "{{ __('message.yes_delete') }}",
            updateQuestion: "{{ __('message.update_deal_status_question') }}",
            yesUpdate: "{{ __('message.yes_update') }}",
            markPaidTitle: "{{ __('message.mark_paid_title') }}",
            markPaidText: "{{ __('message.mark_paid_text') }}",
            yesMarkPaid: "{{ __('message.yes_mark_paid') }}",
            cancel: "{{ __('message.cancel') }}",
            success: "{{ __('message.success') }}",
            success: "{{ __('message.success') }}",
            buyDeals: "{{ __('message.buy_deals') }}",
            sellDeals: "{{ __('message.sell_deals') }}",
            deleteWarningCustomer: "{{ __('message.deleteWarningCustomer') }}",

        }
    </script>
    <!-- Page JS -->
    <script src="{{ asset('admin-assets/js/dashboards-analytics.js') }}"></script>




</body>

</html>
