@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-10">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.profile_detail')
                    </h5>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.profile.update', ['id' => $admin->id]) }}" class="ajaxSubmit"
                                    id="ajaxSubmit" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">


                                        <div class="col-12">
                                            <div class="row my-3">
                                                <label for="Name"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.name')</label>
                                                <div class="col-md-10">
                                                    <input type="text"
                                                        class="form-control text-capitalize @error('name') is-invalid @enderror"
                                                        id="name" name="name"
                                                        value="{{ old('email', $admin->name) }}">
                                                    @error('name')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="email"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.customer_list_email')</label>
                                                <div class="col-md-10">
                                                    <input type="text" name="email"
                                                        class="form-control @error('email') is-invalid @enderror"
                                                        id="email" value="{{ old('email', $admin->email) }}">
                                                    @error('email')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="mobile"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.customer_list_mobile')</label>
                                                <div class="col-md-10">
                                                    <input type="tel" name="mobile_number" id="phone"
                                                        class="form-control  @error('email') is-invalid @enderror"
                                                        id="mobile"
                                                        value="{{ old('mobile_number', $admin->mobile_number) }}">
                                                    @error('mobile_number')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                    <input type="hidden" name="dial_code" id="dial_code"
                                                        value="{{ $admin->dial_code }}">
                                                    <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                                        value="{{ $admin->dial_code_iso }}">
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="image"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.image')</label>
                                                <div class="col-md-10">
                                                    <input type="file" name="image" class="form-control"
                                                        id="image">
                                                    <div class="image mt-4">
                                                        <img width='100'
                                                            src="{{ asset('uploads/admin/' . $admin->image) }}"
                                                            class="img-fluid" alt="default image">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row ">
                                        <div class="col-md-12 offset-md-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> @lang('message.save_details')
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
    @section('top_scripts')
        <script>
            let initial_country = '{{ strtolower($admin->dial_code_iso) }}';
        </script>
    @endsection
