@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <script>
        let earningTypes = [];
        let earningsData = [];
    </script>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (
                $authUser->hasPermissionTo('list - ongoing deals') ||
                    $authUser->hasPermissionTo('list - Cancelled Deals') ||
                    $authUser->hasPermissionTo('list - hold amount deals') ||
                    $authUser->hasPermissionTo('list - dispute deals') ||
                    $authUser->hasPermissionTo('buy and sell statistics - dashboard') ||
                    $authUser->hasPermissionTo('earnings chart - dashboard') ||
                    $authUser->id == 1)
                <div class="row">
                    @if (
                        $authUser->hasPermissionTo('list - ongoing deals') ||
                            $authUser->hasPermissionTo('list - Cancelled Deals') ||
                            $authUser->hasPermissionTo('list - hold amount deals') ||
                            $authUser->hasPermissionTo('list - dispute deals') ||
                            $authUser->id == 1)
                        <div class="col-md-8">
                            <div class="row ">
                                {{-- {{ dd($authUser) }} --}}
                                @if ($authUser->hasPermissionTo('list - ongoing deals') || $authUser->id == 1)
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="{{ asset('admin-assets/img/icons/circular.png') }}"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="{{ route('admin.deals.ongoing') }}">
                                                    <span class="fw-semibold d-block mb-1 text-success"> @lang('message.on_going_deals'):
                                                        {{ $data['ongoingDeals']['count'] ?? 0 }}</span>
                                                </a>


                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['ongoingDeals']['usd_total'], USD, 0, 1) }}

                                                    <span class="text-danger"> ({{ $data['ongoingDeals']['usd_deals'] }}
                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['ongoingDeals']['mxn_total'], MXN, 0, 1) }}
                                                    <span class="text-danger">({{ $data['ongoingDeals']['mxn_deals'] }}
                                                        Deals)</span>
                                                </h5>


                                                {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if ($authUser->hasPermissionTo('list - dispute deals') || $authUser->id == 1)
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="{{ asset('admin-assets/img/icons/disputes.png') }}"
                                                            alt="disputed deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="{{ route('admin.deals.disputed') }}">
                                                    <span class="fw-semibold d-block mb-1 text-success"> @lang('message.disputed_deals'):
                                                        {{ $data['disputedDeals']['count'] ?? 0 }}</span>
                                                </a>


                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['disputedDeals']['usd_total'], USD, 0, 1) }}

                                                    <span class="text-danger"> ({{ $data['disputedDeals']['usd_deals'] }}
                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['disputedDeals']['mxn_total'], MXN, 0, 1) }}
                                                    <span class="text-danger">({{ $data['disputedDeals']['mxn_deals'] }}
                                                        Deals)</span>
                                                </h5>

                                                {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if ($authUser->hasPermissionTo('list - Cancelled Deals') || $authUser->id == 1)
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="{{ asset('admin-assets/img/icons/cancelled.png') }}"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="{{ route('admin.deals.cancelled') }}">
                                                    <span class="text-success fw-semibold d-block mb-1"> @lang('message.cancel_deals'):
                                                        {{ $data['cancelDeals']['count'] ?? 0 }}</span>
                                                </a>



                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['cancelDeals']['usd_total'], USD, 0, 1) }}

                                                    <span class="text-danger"> ({{ $data['cancelDeals']['usd_deals'] }}
                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['cancelDeals']['mxn_total'], MXN, 0, 1) }}
                                                    <span class="text-danger">({{ $data['cancelDeals']['mxn_deals'] }}
                                                        Deals)</span>
                                                </h5>

                                                {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if ($authUser->hasPermissionTo('list - hold amount deals') || $authUser->id == 1)
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="{{ asset('admin-assets/img/icons/pause.png') }}"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="{{ route('admin.deals.holdAmount') }}">
                                                    <span class="fw-semibold d-block mb-1 text-success"> @lang('message.hold_amount_deals'):
                                                        {{ $data['holdDeals']['count'] ?? 0 }}</span>
                                                </a>
                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['holdDeals']['usd_total'], USD, 0, 1) }}

                                                    <span class="text-danger"> ({{ $data['holdDeals']['usd_deals'] }}
                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    {{ formatCurrency($data['holdDeals']['mxn_total'], MXN, 0, 1) }}
                                                    <span class="text-danger">({{ $data['holdDeals']['mxn_deals'] }}
                                                        Deals)</span>
                                                </h5>
                                                {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                    @if ($authUser->hasPermissionTo('buy and sell statistics - dashboard') || $authUser->id == 1)
                        <div class="col-md-4">
                            <div class=" order-0 mb-4">
                                <div class="card h-100">
                                    <div class="">
                                        <div class="card-title mb-0">
                                            <div class="commisison-display p-4">
                                                <h6 class="m-0 ">@lang('message.transfer_fees') : </h6>
                                                <div class="total_commision_currency">
                                                    <h6 class="mb-2">
                                                        {{ formatCurrency($data['commissionUSD'], USD, 0, 1) }}
                                                    </h6>
                                                    <h6 class="mb-0">
                                                        {{ formatCurrency($data['commissionMXN'], MXN, 0, 1) }}
                                                    </h6>
                                                </div>



                                            </div>


                                        </div>

                                    </div>

                                </div>
                            </div>
                            <div class=" order-0 mb-4">
                                <div class="card h-100">
                                    <div class="card-header d-flex align-items-center justify-content-between pb-0">
                                        <div class="card-title mb-0">
                                            <h5 class="m-0 me-2">@lang('message.sale_statistics')</h5>

                                        </div>

                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div class="d-flex flex-column align-items-center gap-1">
                                                <h2 class="mb-2">{{ $data['totalDeals'] }}</h2>
                                                <span>@lang('message.total_deals')</span>
                                            </div>
                                            <script>
                                                var totalBuyDeals = @json($data['totalBuyDeals'] ?? 0);
                                                var totalSellDeals = @json($data['totalSellDeals'] ?? 0);
                                            </script>
                                            <div id="orderStatisticsChart"></div>
                                        </div>
                                        <ul class="p-0 m-0">
                                            <li class="d-flex mb-4 pb-1">
                                                <div class=" flex-shrink-0 me-3">
                                                    <img src="{{ asset('admin-assets/img/sell.png') }}" alt="">
                                                </div>
                                                <div
                                                    class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                    <div class="me-2 ">
                                                        <h6 class="mb-0 seller-color"> @lang('message.seller')</h6>

                                                    </div>
                                                    <div class="user-progress">
                                                        <small class="fw-semibold">{{ $data['totalSellDeals'] }}</small>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="d-flex mb-4 pb-1">
                                                <div class=" flex-shrink-0 me-3">
                                                    <img src="{{ asset('admin-assets/img/buy.png') }}" alt="">
                                                </div>
                                                <div
                                                    class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                    <div class="me-2 ">
                                                        <h6 class="mb-0 buyer-color"> @lang('message.buyer')</h6>

                                                    </div>
                                                    <div class="user-progress">
                                                        <small class="fw-semibold">{{ $data['totalBuyDeals'] }}</small>
                                                    </div>
                                                </div>
                                            </li>


                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                @if ($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1)
                    <div class="row">
                        <div class="col-12">
                            <div class="card">

                                <div class="card-body">
                                    <div class="years-selection">
                                        {{-- <label for="">Select Year: </label> --}}
                                        <select name="earningsYears" id="earningsYears" onchange="updateChart()"
                                            class="form-select">
                                            <option value="all">All</option>
                                            @foreach ($data['availableYears'] as $year)
                                                <option value="{{ $year }}"
                                                    {{ $year == $data['selectedYear'] ? 'selected' : '' }}>
                                                    {{ $year }}</option>
                                            @endforeach



                                        </select>


                                    </div>
                                    <h5 class="text-center" id="chart_title">
                                        {{ __('message.yearly_earnings', ['year' => $data['selectedYear']]) }}
                                    </h5>
                                    <div>
                                        <canvas style="height:250px!important;" id="myChart"></canvas>
                                    </div>

                                </div>


                                @if ($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1)
                                    <script>
                                        earningTypes = @json($data['earningTypes']);
                                        usdData = @json($data['usdData']);
                                        mxnData = @json($data['mxnData']);
                                    </script>
                                @endif

                            </div>
                        </div>
                        {{-- <div class="excel-btn text-right">
                    <a href="{{ route('admin.earnings.export') }}">
                        <img src="{{ asset('admin-assets/img/icons/download-excel-file.png') }}"
                            alt="Download Earnings Report">
                    </a>
                </div> --}}

                    </div>
                @endif
            @else
                <div class="row">
                    <div class="col-12">
                        <div class="row ">
                            <div class="col-lg-6 col-md-12 col-6 mb-4">
                                <div class="card">
                                    <div class="card-body">


                                        <h3 class="card-title mb-2">
                                            @lang('message.no_content')

                                        </h3>
                                        {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>
            @endif
        </div>
        <!-- / Content -->

    @endsection
    @section('scripts')
        @if ($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1)
            <script>
                const ctx = document.getElementById('myChart');

                const myChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: earningTypes,
                        datasets: [{
                                label: 'USD',
                                data: usdData,
                                backgroundColor: 'rgba(54, 162, 235, 0.7)'
                            },
                            {
                                label: 'MXN',
                                data: mxnData,
                                backgroundColor: 'rgba(255, 99, 132, 0.7)'
                            }
                        ]
                    },
                    options: {
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                ticks: {
                                    callback: function(value) {
                                        return '$' + value; // or 'MX$' if you want
                                    }
                                }
                            }
                        }
                    }
                });

                function updateChart() {
                    let earningsYears = $('#earningsYears').val();

                    $.ajax({
                        url: "{{ route('admin.dashboard.getEarnings') }}",
                        type: "GET",
                        data: {
                            requestedData: earningsYears
                        },
                        success: function(response) {
                            if (response.status === true && response.statusCode === 200) {
                                let earnings = response.extra.data;
                                myChart.data.labels = earnings.earningTypes;
                                myChart.data.datasets[0].data = earnings.usdData || [];
                                myChart.data.datasets[1].data = earnings.mxnData || [];
                                myChart.update();
                                $("#chart_title").html(response.extra.title);
                            }
                        },
                        error: function(xhr) {
                            console.error("Error fetching earnings data:", xhr.responseText);
                        }
                    });
                }
                //submit export excel form exportBtn
                $('#exportBtn').on('click', function(e) {
                    e.preventDefault();
                    $('#exportExcel').submit();
                })
            </script>
        @endif
    @endsection
