@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-10">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.change_password')
                    </h5>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.profile.passwordUpdate', ['id' => $admin->id]) }}"
                                    id="ajaxSubmit" class="ajaxSubmit" enctype="multipart/form-data" method="POST">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">


                                        <div class="col-12">
                                            <div class="row my-3">
                                                <label for="old_password"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.current_password')</label>
                                                <div class="col-md-10">
                                                    <input type="text"
                                                        class="form-control  @error('old_password') is-invalid @enderror"
                                                        id="old_password" name="old_password" value="">
                                                    @error('old_password')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="row my-3">
                                                <label for="Name"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.new_password')</label>
                                                <div class="col-md-10">
                                                    <input type="text"
                                                        class="form-control  @error('new_password') is-invalid @enderror"
                                                        id="new_password" name="new_password" value="">
                                                    @error('new_password')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="row my-3">
                                                <label for="Name"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.confirm_password')</label>
                                                <div class="col-md-10">
                                                    <input type="text"
                                                        class="form-control @error('confirm_password') is-invalid @enderror"
                                                        id="confirm_password" name="confirm_password" value="">
                                                    @error('confirm_password')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="row ">
                                        <div class="col-md-12 offset-md-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> @lang('message.save_details')
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
    @section('top_scripts')
        <script>
            let initial_country = '{{ strtolower($admin->dial_code_iso) }}';
        </script>
    @endsection
