@extends('admin.layouts.main')
@section('title', 'Edit Customer')
@section('content')
    <div class="content-wrapper ">
        <div class="content-wrapper">
            <div class="container-xxl flex-grow-1 container-p-y">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <!-- Basic Layout -->
                <div class="row ">
                    <div class="col-md-7">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="mb-0 text-dark text-uppercase">
                                    @lang('message.view_deal') #{{ $deal->deal_number }}

                                </h4>
                                <h5>
                                    @if (!empty($deal->end_reason))
                                        {!! getDealstatusWithColor($deal->end_reason) !!}
                                    @endif
                                    {!! getDealstatusWithColor($deal->deal_status) !!}

                                    @if ($deal->is_hold == 1)
                                        <span class="badge bg-warning">@lang('message.amount_hold')</span>
                                    @endif

                                </h5>
                            </div>
                            <div class="card-body">
                                @if ($deal->deal_status === COMPLETED || $deal->end_reason === COMPLETED)
                                    <div class="d-flex justify-space-between">
                                        @if (($deal->deal_status === COMPLETED || $deal->end_reason === COMPLETED) && $deal->completed_by_type === 'admin')
                                            @php
                                                $admin = $deal->completedByAdmin;
                                                $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                            @endphp
                                            <p class="text-danger italic">@lang('message.completed_by') {{ $adminRole }}</p>
                                        @endif

                                        <p class=" italic">
                                            <b>@lang('message.updated_on'):</b>
                                            {{ dateFormat($deal->status_datetime, DISPLAY_DATE) }}
                                        </p>
                                    </div>
                                @elseif ($deal->deal_status === CANCEL || $deal->end_reason === CANCEL)
                                    <div class="d-flex justify-space-between">
                                        <p class=" italic">
                                            <span class="text-danger">
                                                @if ($deal->cancel_type != '' && $deal->cancel_type === 'admin')
                                                    @php
                                                        $admin = $deal->cancelByAdmin;
                                                        $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                                    @endphp
                                                    {{ __('message.cancelled_by') }} {{ $adminRole }}
                                                @elseif($deal->cancel_type != '' && $deal->cancel_type === CUSTOMER)
                                                    <strong>{{ __('message.cancelled_by') }} :</strong>
                                                    @php
                                                        $customer =
                                                            $deal->from_customer_id == $deal->cancel_by
                                                                ? $deal->fromCustomer
                                                                : $deal->toCustomer;
                                                        [$customerLabel, $customerType] = getCustomerType(
                                                            $deal,
                                                            $deal->cancel_by,
                                                        );
                                                    @endphp
                                                    {{ $customer->full_name }}
                                            </span><span class="text-capitalize text-success">({{ $customerLabel }})</span>
                                @endif
                                </p>
                                <p class=" italic">
                                    <b>@lang('message.updated_on'):</b>
                                    {{ dateFormat($deal->status_datetime, DISPLAY_DATE) }}
                                </p>
                            </div>
                            <p class="italic text-capitalize"><b>Reason:</b>
                                @if ($deal->cancel_reason != '')
                                    {{ $deal->cancel_reason }}
                                @else
                                    @lang('message.not_available')
                                @endif
                            </p>
                            {{-- dispute entry --}}
                        @elseif(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED]) ||
                                in_array($deal->end_reason, [DISPUTE_ACCEPTED, DISPUTE_REJECTED]))
                            <div class="d-flex justify-space-between">
                                <p class=" italic">
                                    <span class="text-danger">
                                        @if ($deal->dispute_request_by_type != '' && $deal->dispute_request_by_type === 'admin')
                                            @php
                                                $admin = $deal->disputeByAdmin;
                                                $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                            @endphp
                                            @lang('message.disputed_by') {{ $adminRole }}
                                        @elseif($deal->dispute_request_by_type != '' && $deal->dispute_request_by_type === CUSTOMER)
                                            <strong>@lang('message.disputed_by') :</strong>
                                            @php
                                                $customer =
                                                    $deal->from_customer_id == $deal->dispute_request_by_id
                                                        ? $deal->fromCustomer
                                                        : $deal->toCustomer;
                                                [$customerLabel, $customerType] = getCustomerType(
                                                    $deal,
                                                    $deal->dispute_request_by_id,
                                                );
                                                $customerTag = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->dispute_request_by_id,
                                                );
                                            @endphp
                                            {{ $customer->full_name }}
                                    </span><span
                                        class="text-uppercase badge {{ $customerTag['bg'] }}">{{ $customerLabel }}</span>
                                </p>
                                @endif
                                <p class=" italic">
                                    <b>@lang('message.updated_on'):</b>
                                    {{ dateFormat($deal->status_datetime, DISPLAY_DATE) }}
                                </p>
                            </div>
                            <p class="italic"><b>@lang('message.reason'):</b>
                                @if ($deal->dispute_reason_id != '')
                                    @php
                                        $disputeReason = collect(disputeReasons())->firstWhere(
                                            'key',
                                            $deal->dispute_reason_id,
                                        );
                                    @endphp
                                    {{ $disputeReason['value'] }}
                                @else
                                    {{ $deal->dispute_reason }}
                                @endif
                            </p>
                            @endif
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label">@lang('message.created_at')</label>
                                        <p>{{ dateFormat($deal->created_at, DISPLAY_DATETIME) }}</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label">@lang('message.title')</label>
                                        <p class="text-capitalize">{{ $deal->deal_title }}</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label ">@lang('message.amount')</label>
                                        <p> {{ formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="py-3">
                                        <label class="form-label">@lang('message.created_by') :</label>
                                        <div class="user-info-thumb  text-dark">
                                            @php
                                                $fromCustomerTypeClass = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->from_customer_id,
                                                );
                                                $toCustomerTypeClass = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->to_customer_id,
                                                );

                                            @endphp
                                            <p class="text-capitalize"><label
                                                    for="">{{ $deal->fromCustomer->full_name }}</label>
                                                <span class="badge {{ $fromCustomerTypeClass['bg'] }}">
                                                    {{ getCustomerType($deal, $deal->from_customer_id)[0] }}
                                                </span>
                                                {!! deletedCustomer($deal->fromCustomer) !!}
                                            </p>
                                            {{-- <p id="from_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-envelope'></i>
                                                <span>{{ $deal->fromCustomer->email }}</span>

                                            </p> --}}
                                            <p id="to_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-mobile-alt'></i>
                                                <span>
                                                    {{ $deal->fromCustomer->dial_code }}
                                                    {{ $deal->fromCustomer->mobile_number }}
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="py-3">
                                        <label class="form-label">@lang('message.created_for'): </label>
                                        <div class="user-info-thumb  text-dark">
                                            <p class="text-capitalize"><label
                                                    for="">{{ $deal->toCustomer->full_name }}</label>
                                                <span class="badge {{ $toCustomerTypeClass['bg'] }}">
                                                    {{ getCustomerType($deal, $deal->to_customer_id)[0] }}
                                                </span>
                                                {!! deletedCustomer($deal->toCustomer) !!}
                                            </p>
                                            {{-- <p id="to_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-envelope'></i>
                                                <span>{{ $deal->toCustomer->email }}</span>
                                            </p> --}}
                                            <p id="to_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-mobile-alt'></i>
                                                <span>
                                                    {{ $deal->toCustomer->dial_code }}
                                                    {{ $deal->toCustomer->mobile_number }}
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- deal images display section --}}
                            @if ($deal->images && $deal->images->count() > 0)
                                <label class="form-label">@lang('message.deal_item_images')</label>
                                <div class="row">
                                    @foreach ($deal->images as $image)
                                        <div class="col-md-4 pt-3">

                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="{{ asset(DEAL_IMAGES . '/' . $image->image) }}" target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="{{ asset(DEAL_IMAGES . '/' . $image->image) }}"
                                                        alt="">
                                                </a>
                                            </div>


                                        </div>
                                    @endforeach



                                </div>
                            @endif
                            {{-- shipping and payment proof section --}}
                            @if (!empty($deal->payment_proof) || !empty($deal->shipping_proof))
                                <div class="row">
                                    @if (!empty($deal->payment_proof))
                                        <div class="col-md-6 pt-3">
                                            <label class="form-label">@lang('message.payment_proof')</label>
                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="{{ asset(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof) }}"
                                                    target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="{{ asset(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof) }}"
                                                        alt="">
                                                </a>
                                            </div>
                                            @php
                                                if ($deal->payment_status == ACCEPTED) {
                                                    $bg = 'bg-success';
                                                } elseif ($deal->payment_status == 'rejected') {
                                                    $bg = 'bg-danger';
                                                } elseif ($deal->payment_status == PENDING) {
                                                    $bg = 'bg-warning';
                                                }
                                            @endphp
                                            <span
                                                class="badge {{ $bg }} start-0 m-2">{{ $deal->payment_status }}</span>
                                            @if ($deal->payment_proof && $deal->deal_status == ACCEPTED)
                                                @if ($deal->payment_status == PENDING)
                                                    {{-- Show Accept + Reject buttons if status is rejected OR pending --}}
                                                    <div class="update-payment-proof-status">
                                                        <h6 class="mb-0 mt-2">Payment Proof Status</h6>
                                                        <form
                                                            action="{{ route('admin.deals.updatePaymentDocumentStatus', $deal->id) }}"
                                                            method="post" class="ajaxSubmit mt-3">
                                                            @csrf
                                                            <select name="payment_proof_statuses"
                                                                id="payment_proof_statuses" class="form-select">
                                                                <option value="">Select</option>
                                                                <option value="{{ ACCEPTED }}">Accepted</option>
                                                                <option value="{{ REJECTED }}">Rejected</option>
                                                            </select>
                                                            <textarea class="form-control mt-2" placeholder="Reason (Optional)" name="payment_tarea" id="payment_tarea"
                                                                rows="2"></textarea>
                                                            <button type="submit"
                                                                class="mt-2 btn btn-primary btn-sm">Submit</button>
                                                        </form>

                                                    </div>
                                                @endif

                                                <div class="mt-2">
                                                    @if (
                                                        $deal->latestPaymentRejection?->reason &&
                                                            $deal->deal_status == ACCEPTED &&
                                                            !in_array($deal->payment_status, [ACCEPTED]))
                                                        <strong>Reason:</strong>
                                                        {{ $deal->latestPaymentRejection?->reason }} <br>
                                                        <small>
                                                            By {{ $deal->latestPaymentRejection?->admin->name }}
                                                            on
                                                            {{ $deal->latestPaymentRejection?->created_at?->format('d M Y H:i') }}
                                                        </small>
                                                    @endif


                                                </div>

                                            @endif
                                            {{-- Payment rejection history --}}
                                            @if ($deal->paymentRejections->count() > 0)
                                                <div class="mt-3">
                                                    <strong>Rejection History
                                                        ({{ $deal->paymentRejections?->count() }})</strong>
                                                    <ul>
                                                        @foreach ($deal->paymentRejections as $index => $rejection)
                                                            <li>
                                                                Attempt {{ $index + 1 }}:
                                                                {{ $rejection?->created_at->format('d M Y H:i') }}
                                                                (Reason: {{ $rejection?->reason ?? 'N/A' }})
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                    @if (!empty($deal->shipping_proof))
                                        <div class="col-md-6 pt-3">
                                            <label class="form-label">@lang('message.shipping_proof')</label>
                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="{{ asset(SHIPPING_PROOF_PATH . '/' . $deal->shipping_proof) }}"
                                                    target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="{{ asset(SHIPPING_PROOF_PATH . '/' . $deal->shipping_proof) }}"
                                                        alt="">
                                                </a>
                                            </div>
                                            @php
                                                if ($deal->shipping_status == ACCEPTED) {
                                                    $bg = 'bg-success';
                                                } elseif ($deal->shipping_status == 'rejected') {
                                                    $bg = 'bg-danger';
                                                } elseif ($deal->shipping_status == PENDING) {
                                                    $bg = 'bg-warning';
                                                }
                                            @endphp
                                            <span
                                                class="badge {{ $bg }} start-0 m-2">{{ $deal->shipping_status }}</span>
                                            @if ($deal->shipping_proof && $deal->deal_status == ACCEPTED)
                                                @if ($deal->shipping_status == PENDING)
                                                    {{-- Show Accept + Reject buttons if status is rejected OR pending --}}
                                                    <div class="update-shipping-proof-status">
                                                        <h6 class="mb-0 mt-2">Shipping Proof Status</h6>
                                                        <form
                                                            action="{{ route('admin.deals.updateShippingDocumentStatus', $deal->id) }}"
                                                            method="post" class="ajaxSubmit mt-3">
                                                            @csrf
                                                            <select name="shipping_proof_statuses"
                                                                id="shipping_proof_statuses" class="form-select">
                                                                <option value="">Select</option>
                                                                <option value="{{ ACCEPTED }}">Accepted</option>
                                                                <option value="{{ REJECTED }}">Rejected</option>
                                                            </select>
                                                            <textarea class="form-control mt-2" placeholder="Reason (Optional)" name="shipping_tarea" id="shipping_tarea"
                                                                rows="2"></textarea>
                                                            <button type="submit"
                                                                class="mt-2 btn btn-primary btn-sm">Submit</button>
                                                        </form>

                                                    </div>
                                                @endif

                                                <div class="mt-2">
                                                    @if (
                                                        $deal->latestShippingRejection?->reason &&
                                                            $deal->deal_status == ACCEPTED &&
                                                            !in_array($deal->shipping_status, [ACCEPTED]))
                                                        <strong>Reason:</strong>
                                                        {{ $deal->latestShippingRejection?->reason }} <br>
                                                        <small>
                                                            By {{ $deal->latestShippingRejection?->admin->name }}
                                                            on
                                                            {{ $deal->latestShippingRejection?->created_at?->format('d M Y H:i') }}
                                                        </small>
                                                    @endif


                                                </div>

                                            @endif
                                            {{-- shipping rejection history --}}
                                            @if ($deal->shippingRejections->count() > 0)
                                                <div class="mt-3">
                                                    <strong>Rejection History
                                                        ({{ $deal->shippingRejections?->count() }})</strong>
                                                    <ul>
                                                        @foreach ($deal->shippingRejections as $index => $rejection)
                                                            <li>
                                                                Attempt {{ $index + 1 }}:
                                                                {{ $rejection?->created_at->format('d M Y H:i') }}
                                                                (Reason: {{ $rejection?->reason ?? 'N/A' }})
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            @endif

                            {{-- dispute docs list --}}
                            @if (in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED]))
                                @if ($deal->disputeDocs->isNotEmpty())
                                    <div id="dispute-docs-section">
                                        <hr>
                                        <h5>@lang('message.dispute_documents')</h5>
                                        @if ($sellerDisputeDocs->isNotEmpty())
                                            <h6 class="seller-color mb-0">By Seller:</h6>
                                            <div class="row">
                                                @foreach ($sellerDisputeDocs as $disputeDoc)
                                                    <div class="col-lg-2 col-md-4 col-sm-6 py-3">
                                                        @if ($disputeDoc->file_type == 'image')
                                                            <a data-fancybox="gallery" class="shdw"
                                                                href="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}"
                                                                target="_blank">
                                                                <img width="" class="media-item"
                                                                    src="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}"
                                                                    alt="">
                                                            </a>
                                                        @elseif ($disputeDoc->file_type == 'doc')
                                                            <a target="_blank" class="shdw"
                                                                href="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}">
                                                                <img width="" class="media-item"
                                                                    src="{{ asset(DISPUTED_DOCS_PATH . '/document.png') }}"
                                                                    alt="">
                                                            </a>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                        {{-- //by buyer --}}
                                        @if ($buyerDisputeDocs->isNotEmpty())
                                            <h6 class="buyer-color mb-0">By Buyer:</h6>
                                            <div class="row">
                                                @foreach ($buyerDisputeDocs as $disputeDoc)
                                                    <div class="col-lg-2 col-md-4 col-sm-6 py-3">
                                                        @if ($disputeDoc->file_type == 'image')
                                                            <a data-fancybox="gallery" class="shdw"
                                                                href="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}"
                                                                target="_blank">
                                                                <img width="" class="media-item"
                                                                    src="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}"
                                                                    alt="">
                                                            </a>
                                                        @elseif ($disputeDoc->file_type == 'doc')
                                                            <a target="_blank" class="shdw"
                                                                href="{{ asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path) }}">
                                                                <img width="" class="media-item"
                                                                    src="{{ asset(DISPUTED_DOCS_PATH . '/document.png') }}"
                                                                    alt="">
                                                            </a>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif

                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>

                </div>
                <div class="col-md-5">
                    <div class="card mb-2">
                        <div class="card-body ">
                            <h5>@lang('message.amount_details') :</h5>
                            {{-- //check payment status --}}
                            @php
                                $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
                            @endphp
                            <h6 style = "color:#{{ $paymentStatusResult['color'] }}">
                                <i class='bx {{ $paymentStatusResult['icon'] }}'></i>
                                {{ $paymentStatusResult['payment_status'] }}
                            </h6>

                            <div class="payemnt-status">
                                <h6></h6>
                            </div>
                            <div class="d-flex">
                                <div class="col-sm-6">@lang('message.deal_amount') :</div>
                                <div class="col-sm-6">
                                    {{ formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1) }}</div>
                            </div>
                            <div class="d-flex">
                                <div class="col-sm-6">@lang('message.transfer_fees'):</div>
                                <div class="col-sm-6">
                                    {{ formatCurrency($deal->admin_earnings, $deal->currency_code, 0, 1) . ' (' . $deal->transfer_fees_in_percent . '%)' }}
                                </div>
                            </div>
                            <hr>
                            <div class="d-flex">
                                <div class="col-sm-6">@lang('message.total_deal_amount'):</div>
                                <div class="col-sm-6">
                                    {{ formatCurrency($deal->total_deal_Amount, $deal->currency_code, 0, 1) }}

                                </div>
                            </div>
                            @if (in_array($deal->deal_status, [PENDING, ACCEPTED, TRANSIT, DELIVERED]))
                                <div class="d-flex mt-4">
                                    <div class="col-sm-6">@lang('message.amount_to_be_released') :</div>
                                    <div class="col-sm-6">
                                        <span
                                            id="actualAmountDisplay">{{ formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1) }}</span>
                                    </div>
                                </div>
                            @endif
                            @if ($deal->is_release == 1)
                                <div class="d-flex mt-2">
                                    <div class="col-sm-6">@lang('message.released_amount'):</div>
                                    <div class="col-sm-6">
                                        <span>{{ formatCurrency($deal->release_amount, $deal->currency_code, 0, 1) }}</span>
                                    </div>
                                </div>
                                <div class="d-flex">

                                    </span>
                                </div>
                            @endif
                            {{-- //set paid status to 1 --}}
                            @if (
                                $deal->is_paid == 0 &&
                                    $deal->deal_status == ACCEPTED &&
                                    $deal->payment_proof &&
                                    file_exists(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof) &&
                                    $deal->payment_status == ACCEPTED)
                                <div class="mark-paid">
                                    <form action="{{ route('admin.deal.markPaid', $deal->id) }} " method="POST"
                                        class="ajaxSubmit ">
                                        @csrf
                                        <button
                                            class="btn
                                        btn-primary mark-paid-btn"
                                            id="mark-paid-btn" onclick="markPaid({{ $deal->id }})">
                                            <i class='bx bx-check-circle'></i>
                                            @lang('message.mark_paid')</button>
                                    </form>

                                </div>
                            @endif
                        </div>

                        @if (in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED, COMPLETED, CANCEL]) &&
                                $deal->is_release == 0 &&
                                $deal->is_hold == 1 &&
                                $deal->is_paid == 1)
                            <div class="d-flex
                                        padding-x15 mb-2 ">
                                <div class="col-sm-6">@lang('message.amount_to_be_released') :</div>
                                <div class="col-sm-6">{{ CURRENCY }}
                                    <span id="actualAmountDisplay">{{ $deal->deal_amount }}</span>
                                </div>
                            </div>
                            @if ($authUser->hasPermissionTo('amount release - deal detail') || $authUser->id == 1)
                                <form action="{{ route('admin.dealAmount.update', $deal->id) }}"
                                    class="padding-x15 ajaxSubmit" id="ajaxSubmit1" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mt-2">
                                        <div class="col-sm-12">



                                            @if ($deal->is_hold == 1 && in_array($deal->deal_status, [CANCEL, COMPLETED]))
                                                @if ($deal->is_hold == 1 && in_array($deal->deal_status, [CANCEL]))
                                                    <hr>
                                                    <div class="d-flex mt-2">
                                                        <div class="col-sm-6">@lang('message.amount_released_to'):</div>
                                                        <div class="col-sm-6">
                                                            <select name="amount_released_to" required
                                                                id="amount_released_to" class="select2">
                                                                <option value="">@lang('message.select')</option>

                                                                <option value="{{ $deal->from_customer_id }}"
                                                                    @if (!@empty($deal->fromCustomer->deleted_at)) disabled @endif>
                                                                    {{ $fromCustomerPrefix }}
                                                                    @if (!empty($deal->fromCustomer->deleted_at))
                                                                        (Deleted)
                                                                    @endif
                                                                </option>
                                                                <option value="{{ $deal->to_customer_id }}"
                                                                    @if (!@empty($deal->toCustomer->deleted_at)) disabled @endif>
                                                                    {{ $toCustomerPrefix }}
                                                                    @if (!empty($deal->toCustomer->deleted_at))
                                                                        (Deleted)
                                                                    @endif
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                @endif
                                                @if ($deal->is_hold == 1 && in_array($deal->deal_status, [COMPLETED]))
                                                    <div class="row">


                                                        <div class="col-sm-6">

                                                            @lang('message.amount_will_release_to'):


                                                        </div>
                                                        <div class="col-sm-6 text-capitalize px-0">
                                                            {{ $releaseToSeller }}
                                                        </div>
                                                        <input type="hidden" name="completed_relase_to"
                                                            value="{{ $releaseToSellerId }}">

                                                    </div>
                                                @endif
                                                {{-- <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" name="service_charge"
                                                        id="toggleServiceTax">
                                                    <label class="form-check-label" for="toggleServiceTax">
                                                        Deduct Transfer Fees
                                                    </label>
                                                </div> --}}

                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary">@lang('message.release_amount')</button>
                                                </div>
                                            @endif
                                            @if ($deal->is_hold == 1 && in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED]))
                                                <div class="row">


                                                    <div class="col-sm-6">
                                                        @if ($deal->is_release == 1)
                                                            @lang('message.amount_released_to'):
                                                        @else
                                                            @lang('message.amount_will_release_to'):
                                                        @endif

                                                    </div>
                                                    <div class="col-sm-6 text-capitalize px-0">
                                                        {{ $releaseToCustomerInfo }}
                                                    </div>
                                                    <input type="hidden" name="disputed_relase_to"
                                                        value="{{ $releaseToCustomerId }}">

                                                </div>
                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary">@lang('message.release_amount')</button>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </form>
                            @endif
                        @endif
                    </div>
                    @if ($authUser->hasPermissionTo('update status - deal detail') || $authUser->id == 1)
                        @if (!in_array($deal->deal_status, [COMPLETED, CANCEL, CLOSED, DISPUTE_ACCEPTED, DISPUTE_REJECTED]))


                            <div class="card mt-2 mt-2">
                                <div class="card-body">
                                    <form action="{{ route('admin.deals.updateStatus', $deal->id) }}" class="ajaxSubmit"
                                        Id="ajaxSubmit2" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                                        <div class="py-3">
                                            <label class="form-label"
                                                for="basic-default-password">@lang('message.status')</label>
                                            <select name="deal_status" id="deal_status" class="form-select" required>
                                                <option value="">
                                                    {{ __('message.select_status') }}
                                                </option>
                                                @foreach (dealStatusSelection(false, '', $deal->is_hold, $deal->is_paid, $deal->deal_status, $deal->shipping_status, $deal->shipping_proof) as $key => $value)
                                                    @if ($key !== $deal->deal_status)
                                                        <option value="{{ $key }}">
                                                            {{ ucfirst($value) }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>

                                        </div>
                                        {{-- //cancel section --}}
                                        @if ($deal->deal_status == 'cancel' || $deal->end_reason == 'cancel')
                                            @if ($deal->cancel_reason)
                                                <p class="text-capitalize">{{ $deal->cancel_reason }}</p>
                                            @else
                                                <p>@lang('message.no_cancellation_reason_available')</p>
                                            @endif
                                        @endif
                                        <!-- cancel reason dialog box -->
                                        <div id="cancel-section" class="cancel-section disp-none">
                                            <label class="form-label"
                                                for="basic-default-reason">@lang('message.cancel_reason')</label>
                                            <span class="small-text text-danger">(@lang('message.required'))</span>
                                            <textarea name="cancel_reason" id="cancel_reason" class="form-control" rows="2"></textarea>
                                        </div>
                                        <!-- dispute reason dialog box -->
                                        <div id="dispute-section" class="dispute-section disp-none">
                                            <label class="form-label"
                                                for="basic-default-dispute">@lang('message.dispute_reason')</label>
                                            <span class="small-text text-danger">(@lang('message.required'))</span>
                                            <textarea name="dispute_reason" id="dispute_reason" class="form-control" rows="2"></textarea>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary">@lang('message.update_status')</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        @endif
                    @endif
                    @if ($authUser->hasPermissionTo('timeline history - deal detail') || $authUser->id == 1)
                        {{-- display timeline --}}
                        <div class="card mt-2">
                            <div class="card-body">
                                <h5>@lang('message.display_deal_status_timeline')</h5>
                                {{-- <p><b>Created at :</b>
                                {{ \Carbon\Carbon::parse($deal->created_at)->format(DISPLAY_DATETIME) }}
                            </p> --}}

                                <ul class="timeline">
                                    @foreach ($dealStatusHistories as $dealStatusHistory)
                                        @php
                                            $status = displayStatusHistory($dealStatusHistory->status);
                                        @endphp
                                        <li class="timeline-item">
                                            <div class="timeline-dot"></div>
                                            <div class="timeline-content">
                                                <strong>{{ $status['value'] }}</strong>
                                                <small class="text-muted d-block">
                                                    {{ \Carbon\Carbon::parse($dealStatusHistory->created_at)->format(DISPLAY_DATETIME) }}
                                                </small>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            <div class="conversation pt-3">
                @if ($messages->isNotEmpty() || !in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED]))
                    @if ($authUser->hasPermissionTo('conversation - dispute deals') || $authUser->id == 1)
                        @if (in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED]))
                            <h5>@lang('message.dispute_conversation')</h5>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white mb-3">
                                            <h6 class="mb-0 text-white">@lang('message.conversation_to_buyer') :

                                            </h6>
                                        </div>
                                        {{-- list of messages --}}
                                        <div id="buyer-message-list" class="card-body mb-3 mesg-card-height"
                                            style=" overflow-y: auto;">
                                            @include('admin.deal.conversation', [
                                                'messages' => $buyerMessages,
                                            ])
                                        </div>
                                        @if (in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW]))
                                            <div class="card-footer">
                                                <!-- Admin Reply Form -->
                                                <form action="{{ route('admin.dispute.reply') }}" class="ajaxSubmit"
                                                    id="ajaxSubmit3" enctype="multipart/form-data" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="deal_id" id="deal_id"
                                                        value="{{ $deal->id }}">
                                                    <input type="hidden" name="receiver_id"
                                                        value="{{ $buyerId }}">
                                                    <input type="hidden" name="receiver_type" value="customer">
                                                    <input type="hidden" name="get_messages_url" id="get_messages_url"
                                                        value="{{ route('admin.deal.getMessages', $deal->id) }}">
                                                    <div class="input-group">
                                                        <textarea name="message" id="message-input-buyer" class="form-control @error('message') is-invalid @enderror"
                                                            placeholder="Type your response...">{{ old('message') }}</textarea>
                                                        @error('message')
                                                            <p class="invalid-feedback">{{ $message }}</p>
                                                        @enderror
                                                        <button type="submit"
                                                            class="btn btn-primary">@lang('message.send')</button>
                                                    </div>
                                                </form>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white mb-3">
                                            <h6 class="mb-0 text-white">@lang('message.conversation_to_seller') :

                                            </h6>
                                        </div>
                                        {{-- list of messages --}}
                                        <div id="seller-message-list" class="card-body mb-3 mesg-card-height"
                                            style=" overflow-y: auto;">
                                            @include('admin.deal.conversation', [
                                                'messages' => $sellerMessages,
                                            ])
                                        </div>
                                        @if (in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW]))
                                            <div class="card-footer">
                                                <!-- Admin Reply Form -->
                                                <form action="{{ route('admin.dispute.reply') }}" class="ajaxSubmit"
                                                    id="ajaxSubmit3" enctype="multipart/form-data" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="deal_id" id="deal_id"
                                                        value="{{ $deal->id }}">
                                                    <input type="hidden" name="receiver_id"
                                                        value="{{ $sellerId }}">
                                                    <input type="hidden" name="receiver_type" value="customer">
                                                    <input type="hidden" name="get_messages_url" id="get_messages_url"
                                                        value="{{ route('admin.deal.getMessages', $deal->id) }}">
                                                    <div class="input-group">
                                                        <textarea name="message" id="message-input-seller" class="form-control @error('message') is-invalid @enderror"
                                                            placeholder="Type your response...">{{ old('message') }}</textarea>
                                                        @error('message')
                                                            <p class="invalid-feedback">{{ $message }}</p>
                                                        @enderror
                                                        <button type="submit"
                                                            class="btn btn-primary">@lang('message.send')</button>
                                                    </div>
                                                </form>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                        @endif
                    @endif
                @endif
            </div>
        </div>
    </div>
    </div>
@endsection
@section('scripts')
    <script>
        //display cancel reason
        $("#deal_status").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let CANCEL = @json(CANCEL);
            let ON_DISPUTE = @json(ON_DISPUTE);

            //cancel
            if (selectedStatus.trim() === CANCEL) {
                $("#cancel-section").show();
                $('#cancel_reason').attr('required', true);
                //alert()
            } else {
                $("#cancel-section").slideUp();
                $('#cancel_reason').removeAttr('required');
            }

            //dispute
            if (selectedStatus.trim() === ON_DISPUTE) {
                $("#dispute-section").show();
                $('#dispute_reason').attr('required', true);
                //alert()
            } else {
                $("#dispute-section").slideUp();
                $('#dispute_reason').removeAttr('required');
            }
        });

        //display dispute reason

        // Define deal amounts from Laravel


        // Function to update the amount display
        var dealAmount = {{ $deal->deal_amount }};
        // var releaseAmount = {{ $deal->release_amount }};

        function updateAmount() {
            if ($('#toggleServiceTax').is(':checked')) {

                $('#actualAmountDisplay').text(releaseAmount);
            } else {
                $('#actualAmountDisplay').text(dealAmount);
            }
        }

        // Call function on checkbox change
        $('#toggleServiceTax').change(function() {
            updateAmount();
        });

        // Call function on page load to set initial value
        if ($('#toggleServiceTax').length > 0) {
            updateAmount();
        }
        Fancybox.bind("[data-fancybox]", {
            Toolbar: true,
            Thumbs: true,
            loop: true,
        });
        //check if payment proof documnet is rejected then display reason text area 
        $("#payment_proof_statuses").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let REJECTED = @json(REJECTED);

            //cancel
            if (selectedStatus.trim() === REJECTED) {
                $("#payment_tarea").show();
                //$('#cancel_reason').attr('required', true);

            } else {
                $("#payment_tarea").hide();
                //$('#cancel_reason').removeAttr('required');
            }


        });
        //check if shipping proof documnet is rejected then display reason text area 
        $("#shipping_proof_statuses").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let REJECTED = @json(REJECTED);

            //cancel
            if (selectedStatus.trim() === REJECTED) {
                $("#shipping_tarea").show();
                //$('#cancel_reason').attr('required', true);

            } else {
                $("#shipping_tarea").hide();
                //$('#cancel_reason').removeAttr('required');
            }


        });
    </script>
@endsection
