<table class="dataTable dt-responsive table table-hover display align-middle mb-0" style="width:100%">
    <thead>
        <tr>

            <th><span style="width: 50px;" class="sortable" data-sort="deal_number" data-order="asc">
                    @lang('message.deal_number') <i id="sort-icon-deal_number" class="bx bx-sort"></i>
                </span></th>
            <th><span style="width: 100px;" class="sortable" data-sort="created_at" data-order="asc">
                    @lang('message.date') <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span></th>

            <th><span class="sortable" data-sort="deal_title" data-order="asc">
                    @lang('message.name') <i id="sort-icon-deal_title" class="bx bx-sort"></i>

                </span></th>

            <th><span style="width: 100px;" class="sortable" data-sort="deal_amount" data-order="asc">
                    @lang('message.amount') <i id="sort-icon-deal_amount" class="bx bx-sort"></i>

                </span></th>

            <th><span class="sortable" data-sort="deal_status" data-order="asc">

                    @lang('message.deal_status')


                    <i id="sort-icon-deal_status" class="bx bx-sort"></i>
                </span></th>



            <th><span style="width: 200px;">
                    @lang('message.seller_detail')

                    {{-- <i id="sort-icon-t_full_name" class="bx bx-sort"></i> --}}

                </span></th>


            <th><span data-orderable="false" style="width: 200px;">
                    @lang('message.buyer_detail')

                    {{-- <i id="sort-icon-f_full_name" class="bx bx-sort"></i> --}}

                </span></th>

            <th><span>@lang('message.payment_status')</span></th>
            {{-- <th>@lang('message.attention')</th> --}}
            <th></th>

            {{-- <th><span>@lang('message.actions')</span></th> --}}
        </tr>
    </thead>
    @if (isset($deals) && count($deals) > 0)
        <tbody class="table-border-bottom-0">
            @php
                $i = !empty($deals) ? pageIndex($deals) : 1;
            @endphp
            @foreach ($deals as $deal)
                <tr data-href="{{ route('admin.deal.show', $deal->id) }}" class="clickable-row">
                    <td>#{{ $deal->deal_number }}</td>
                    <td>{{ dateFormat($deal->created_at, DISPLAY_DATETIME) }}</td>
                    <td class="text-capitalize">
                        <strong>{{ $deal->deal_title }}</strong>
                    </td>
                    <td class="text-capitalize">
                        <strong>{{ formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1) }}</strong>
                    </td>

                    <td class="text-capitalize">{{ readablestatus($deal->deal_status) }}</td>
                    <td>

                        <strong class="seller-color text-capitalize">{{ $deal->seller_name }}</strong>
                        @if ($deal->seller_deleted_at)
                            <span class='deleted-cust'>@lang('message.customer_deleted')</span>
                        @endif
                        <div class="user-info-thumb">
                            {{-- <p id="from_customer" class="small-text user-info-thumb">
                                <i class='bx bx-envelope'></i>
                                <span>{{ $deal->seller_email }}</span>
                            </p> --}}
                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    {{ $deal->seller_dial_code }}
                                    {{ $deal->seller_mobile_number }}
                                </span>
                            </p>
                        </div>

                    </td>
                    <td style="width: 15px;">
                        <strong class="buyer-color text-capitalize">{{ $deal->buyer_name }}</strong>
                        @if ($deal->buyer_deleted_at)
                            <span class='deleted-cust'>@lang('message.customer_deleted')</span>
                        @endif
                        <div class="user-info-thumb">

                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    {{ $deal->buyer_dial_code }}
                                    {{ $deal->buyer_mobile_number }}
                                </span>
                            </p>
                        </div>

                    </td>
                    <td>

                        @php
                            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
                            //dd($paymentStatusResult);
                        @endphp
                        <span style = "color:#{{ $paymentStatusResult['color'] }}">

                            {{ $paymentStatusResult['payment_status'] }}
                        </span>

                    </td>

                    <td>
                        @if ($deal->status_flag == 'red')
                            <span class="dot-wrapper border  border-danger">
                                <span class="dot bg-danger" title="Payment proof uploaded"></span>
                            </span>
                        @elseif($deal->status_flag == 'yellow')
                            <span class="dot-wrapper border  border-warning">
                                <span class="dot bg-warning" title="Shipping proof uploaded"></span>
                            </span>
                        @elseif($deal->status_flag == 'green')
                            <div class="dot-wrapper border border-custom-success">
                                <span class="dot custom-bg-success" title="Ready to release payment"></span>
                            </div>
                        @else
                            <span></span>
                        @endif
                    </td>

                    {{-- <td>
                        @if ($authUser->hasPermissionTo('view - deal detail') || $authUser->id == 1)
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                    data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.deal.show', $deal->id) }}"><i
                                            class="bx bx-show-alt me-1"></i> @lang('message.view')</a>
                                  



                                </div>
                            </div>
                        @endif
                    </td> --}}

                </tr>
                </a>
            @endforeach
        <tfoot>
            <tr>
                <td class="" colspan="9">
                    <div class="mt-2 d-flex mb-2">
                        <div class="col-sm-6">
                            <div class="" id="records">{!! pageInfo($deals) !!}</div>
                        </div>
                        <div class="col-sm-6">
                            <div class="">
                                {!! $deals->links('pagination::bootstrap-4') !!}
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
        </tbody>
    @else
        {{-- <tbody>
            <tr>
                <td class="alert alert-danger text-center" colspan="8">No Record Found!</td>
            </tr>
        </tbody> --}}
    @endif
</table>
