@extends('admin.layouts.main')
@section('title', 'Edit Customer')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->

        <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Basic Layout -->
                <div class="row">
                    <div class="col-xl">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="mb-0 text-dark text-uppercase">edit customer</h4>

                            </div>
                            <div class="card-body">
                                <div class="row">

                                    <form action="{{ route('admin.customer.update', $customer->id) }}" class="ajaxSubmit"
                                        id="ajaxSubmit" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                                        <div class="row">
                                            <div class="col-md-4 col-sm-12">
                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-fullname">Full Name</label>
                                                    <input type="text"
                                                        class="form-control @error('full_name') is-invalid @enderror"
                                                        id="basic-default-fullname"
                                                        value="{{ old('full_name', $customer->full_name) }}"
                                                        name="full_name" />
                                                    @error('full_name')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>





                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-image">Image</label>
                                                    <input type="file"
                                                        class="form-control @error('image') is-invalid @enderror"
                                                        name="image" id="image">
                                                    @error('image')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                                <div class="reside image">
                                                    @if ($customer->image === null)
                                                        <img width='100'
                                                            src="{{ asset('admin-assets/img/default.png') }}"
                                                            class="img-fluid" alt="default image">
                                                    @else
                                                        <img width='100'
                                                            src="{{ asset('uploads/customers/' . $customer->image) }}"
                                                            class="img-fluid" alt="image">
                                                    @endif

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-12">

                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-email">Email</label>

                                                    <input type="text" name="email" id="basic-default-email"
                                                        class=" form-control @error('email') is-invalid @enderror"
                                                        aria-label="john.doe" value="{{ old('email', $customer->email) }}"
                                                        aria-describedby="basic-default-email2" />

                                                    @error('email')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror


                                                </div>


                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-status">Status</label>
                                                    <select class="form-control @error('status') is-invalid @enderror"
                                                        name="status">
                                                        <option value="active"
                                                            {{ $customer->status == 'active' ? 'selected' : '' }}>Active
                                                        </option>
                                                        <option value="inactive"
                                                            {{ $customer->status == 'inactive' ? 'selected' : '' }}>
                                                            Inactive</option>

                                                    </select>
                                                    @error('status')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>




                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-message">Address</label>
                                                    <textarea name="address" id="basic-default-address" class="form-control">{{ $customer->address }}</textarea>
                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-12">

                                                <div class="mb-3">
                                                    <label class="form-label d-block" for="basic-default-phone">Phone
                                                        No</label>
                                                    <input type="tel" id="phone"
                                                        class="w-100 form-control  @error('mobile_number') is-invalid @enderror"
                                                        name="mobile_number"
                                                        value="{{ old('mobile_number', $customer->mobile_number) }}" />
                                                    @error('mobile_number')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                    <input type="hidden" name="dial_code" id="dial_code"
                                                        value="{{ $customer->dial_code }}">
                                                    <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                                        value="{{ $customer->dial_code_iso }}">
                                                </div>



                                                <div class="mb-3">
                                                    <label class="form-label" for="basic-default-password">Password</label>
                                                    <input type="text" name="password" class="form-control"
                                                        id="password" value="" />

                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label"
                                                        for="basic-default-message">Description</label>
                                                    <textarea name="description" id="basic-default-description" class="form-control">{{ $customer->description }}</textarea>
                                                </div>


                                            </div>
                                            <div class="submit-btn-outer mt-5">
                                                <button type="submit" class="btn btn-primary">Update Details</button>
                                            </div>

                                        </div>
                                    </form>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- / Content -->




    @endsection

    @section('top_scripts')
        <script>
            let initial_country = '{{ strtolower($customer->dial_code_iso) }}';
        </script>
    @endsection
