@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Hoverable Table rows -->
            <div class="card px-4">

                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="row mt-4 mb-4">
                    <div class="col-sm-4">
                        <h3 class=" text-dark">@lang('message.on_dispute_deal_list')</h3>
                    </div>



                    <div class="col-sm-8 ms-auto">
                        <div class="d-flex gap-3">
                            @if ($deals->total() > 0)
                                <a href="{{ route('admin.deals.exportDispute', request()->query()) }}">
                                    <img title="Export Report" width="30"
                                        src="{{ asset('admin-assets/img/icons/download-excel-file.png') }}"
                                        alt="Export Report">
                                </a>
                            @endif
                            <div class="col-sm-4">
                                <select class="select2" name="payment_status" id="payment_status">
                                    <option value="">@lang('message.select_payment_status')</option>

                                    @foreach (paymentReturnedFilterDisputed() as $key => $value)
                                        <option value="{{ $key }}">{{ $value }}</option>
                                    @endforeach

                                </select>
                            </div>
                            <div class="input-group input-group-merge">
                                <span id="basic-icon-default-fullname2" class="input-group-text">
                                    <i class="bx bx-search-alt"></i>
                                </span>

                                <input type="text" id="search" class="form-control" name="keyword"
                                    placeholder="Search">
                            </div>

                            <button type="button" class="btn btn-icon btn-info" data-bs-toggle="offcanvas"
                                href="#filterPanel" role="button" aria-controls="filterPanel">
                                <i class="bx bx-filter"></i>
                            </button>
                        </div>

                        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel" aria-labelledby="filterPanel"
                            aria-modal="true" role="dialog">
                            <div class="offcanvas-header border-bottom">
                                <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                    @lang('message.apply_filter')
                                </h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>

                            <div class="offcanvas-body p-0">
                                <div class="acitivity-timeline p-4">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">@lang('message.per_page')</label>
                                            <select id="per_page" name="" class="form-select w-auto select2">
                                                @foreach (perPage() as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if (request()->routeIs('admin.deals.disputed'))
                                            <input type="hidden" id="pageUrl"
                                                value="{{ route('admin.deals.disputed') }}">
                                        @endif

                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">@lang('message.deal_status')</label>
                                            <select name="deal_status" id="deal_status_filter"
                                                class="form-select w-auto select2">
                                                @foreach (dealStatusFilterDispute(true) as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach

                                            </select>
                                        </div>


                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">@lang('message.deal_type')</label>
                                            <select id="deal_type_filter" class="form-select w-auto select2"
                                                name="deal_type">
                                                @foreach (dealTypeFilter(true) as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach

                                            </select>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">@lang('message.currency_type')</label>
                                            <select id="currency_type_filter" class="form-select w-auto select2"
                                                name="currency_type">
                                                @foreach (currencyTypeFilter(true) as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach

                                            </select>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">@lang('message.from')</label>
                                            <input class="form-control" type="date" name="date-range" id="date">
                                        </div>




                                        <div class="col-md-12 mt-2">
                                            <button id="applyFilter" type="submit"
                                                class="filter-btn btn btn-info btn-border me-1">
                                                <i class="bx bx-check"></i> @lang('message.apply_filter')</button>
                                            </button>
                                            <a href="" class="btn btn-outline-secondary mt-2">
                                                <i class="bx bx-refresh"></i> @lang('message.clear')
                                            </a>
                                        </div>



                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="pagination-table">
                            @include('admin.deal.disputed.pagination')
                        </div>
                    </div>
                </div>

            </div>
            <!--/ Hoverable Table rows -->
        </div>
        <!-- / Content -->
    @endsection
