<table class="dataTable dt-responsive table table-hover display align-middle mb-0" style="width:100%">
    <thead>
        <tr>

            <th><span class="sortable" data-sort="deal_number" data-order="asc">
                    @lang('message.deal_number') <i id="sort-icon-deal_number" class="bx bx-sort"></i>
                </span></th>
            <th><span class="sortable" data-sort="created_at" data-order="asc">
                    @lang('message.date') <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span></th>

            <th><span class="sortable" data-sort="deal_title" data-order="asc">
                    @lang('message.name')<i id="sort-icon-deal_title" class="bx bx-sort"></i>

                </span></th>

            <th><span class="sortable" data-sort="deal_amount" data-order="asc">
                    @lang('message.amount') <i id="sort-icon-deal_amount" class="bx bx-sort"></i>

                </span></th>





            <th><span style="width:300px">

                    @lang('message.seller_detail')


                </span></th>


            <th><span style="width:300px">

                    @lang('message.buyer_detail')



                </span></th>





        </tr>
    </thead>
    @if (isset($deals) && count($deals) > 0)
        <tbody class="table-border-bottom-0">
            @php
                $i = !empty($deals) ? pageIndex($deals) : 1;
            @endphp
            @foreach ($deals as $deal)
                <tr>
                    <td>#{{ $deal->deal_number }}</td>
                    <td>{{ dateFormat($deal->created_at, DISPLAY_DATETIME) }}</td>
                    <td class="text-capitalize">
                        <strong>{{ $deal->deal_title }}</strong>
                    </td>
                    <td class="text-capitalize">
                        <strong>{{ formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1) }}</strong>
                    </td>


                    <td>

                        <strong class="seller-color text-capitalize">{{ $deal->seller_name }}</strong>
                        @if ($deal->seller_deleted_at)
                            <span class='deleted-cust'>@lang('message.customer_deleted')</span>
                        @endif
                        <div class="user-info-thumb">

                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    {{ $deal->seller_dial_code }}
                                    {{ $deal->seller_mobile_number }}
                                </span>
                            </p>
                        </div>

                    </td>
                    <td style="width: 15px;">
                        <strong class="buyer-color text-capitalize">{{ $deal->buyer_name }}</strong>
                        @if ($deal->buyer_deleted_at)
                            <span class='deleted-cust'>@lang('message.customer_deleted')</span>
                        @endif
                        <div class="user-info-thumb">

                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    {{ $deal->buyer_dial_code }}
                                    {{ $deal->buyer_mobile_number }}
                                </span>
                            </p>
                        </div>

                    </td>




                </tr>
            @endforeach
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 d-flex mb-2">
                        <div class="col-sm-6">
                            <div class="" id="records">{!! pageInfo($deals) !!}</div>
                        </div>
                        <div class="col-sm-6">
                            <div class="">
                                {!! $deals->links('pagination::bootstrap-4') !!}
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
        </tbody>
    @else
        {{-- <tbody>
            <tr>
                <td class="alert alert-danger text-center" colspan="8">No Record Found!</td>
            </tr>
        </tbody> --}}
    @endif
</table>
