@foreach ($messages as $message)
    @php
        $admin = Auth::guard('admin')->user();
        $adminImage = $admin->image ? $admin->image : 'default.png';
        if ($message->sender_id == $deal->fromCustomer->id) {
            $senderName = $deal->fromCustomer->full_name;
            $senderImage = $deal->fromCustomer->image
                ? asset(CUSTOMER_PATH) . '/' . $deal->fromCustomer->image
                : asset(USER_DEFAULT_IMG_PATH);
        } elseif ($message->sender_id == $deal->toCustomer->id) {
            $senderName = $deal->toCustomer->full_name;
            $senderImage = $deal->toCustomer->image
                ? asset(CUSTOMER_PATH) . '/' . $deal->toCustomer->image
                : asset(USER_DEFAULT_IMG_PATH);
        } elseif ($message->sender_type == 'admin') {
            $adminUser = $message->adminSender;
            $senderName = $adminUser?->roles?->first()?->name ?? 'Admin';
            $senderImage =
                $adminUser && $adminUser->image
                    ? asset(ADMIN_PATH) . '/' . $adminImage
                    : asset(ADMIN_PATH) . '/default.png';
        }
    @endphp

    <!-- Chat Messages -->
    @if ($message->sender_type == CUSTOMER)
        <div class="mb-3 mt-3 pt-2">
            <div class="d-flex">
                <div class="image px-2 col-1">
                    <img src="{{ $senderImage }}" class="img-fluid chat-img" alt="">
                </div>
                <div class="meta-info col-11">
                    <strong class="text-primary">{{ $senderName }}</strong>
                    <span class="text-primary">{{ $message->message }}</span>
                    <small
                        class="text-muted d-block">{{ \Carbon\Carbon::parse($message->created_at)->format('d-M-Y H:i') }}</small>
                </div>
            </div>

        </div>
    @else
        <div class="mb-3 text-end">
            <div class="d-flex second-party-convo">
                <div class="image px-2 col-1">
                    <img src="{{ $senderImage }}" class="img-fluid chat-img" alt="">
                </div>
                <div class="meta-info col-11">
                    <span class="text-danger">{{ $message->message }}</span>
                    <strong class="text-danger">{{ $senderName }}</strong>

                    <small
                        class="text-muted d-block">{{ \Carbon\Carbon::parse($message->created_at)->format('d-M-Y H:i') }}</small>
                </div>
            </div>

        </div>
    @endif
@endforeach
