<table class="dataTable dt-responsive table table-hover display align-middle mb-0">
    <thead>
        <tr>

            <th><span class="sortable" data-sort="id" data-order="asc">
                    @lang('message.customer_list_cid') <i id="sort-icon-id" class="bx bx-sort"></i>
                </span></th>
            <th><span class="sortable" data-sort="created_at" data-order="asc">
                    @lang('message.customer_list_register') <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span></th>
            <th><span style="width: 120px;" class="sortable" data-sort="full_name" data-order="asc">
                    @lang('message.customer_list_name') <i id="sort-icon-full_name" class="bx bx-sort"></i>

                </span></th>
            {{-- <th><span class="sortable" data-sort="email" data-order="asc">
                    @lang('message.customer_list_email') <i id="sort-icon-email" class="bx bx-sort"></i> --}}

            </span></th>
            <th><span class="sortable" data-sort="mobile_number" data-order="asc">
                    @lang('message.customer_list_mobile') <i id="sort-icon-mobile_number" class="bx bx-sort"></i>

                </span></th>
            <th><span class="sortable" data-sort="status" data-order="asc">
                    @lang('message.customer_list_status') <i id="sort-icon-status" class="bx bx-sort"></i>
                </span></th>

            <th>@lang('message.customer_list_actions')</span></th>
        </tr>
    </thead>
    @if (isset($customers) && count($customers) > 0)
        <tbody class="table-border-bottom-0">
            @php
                $i = !empty($customers) ? pageIndex($customers) : 1;
            @endphp
            @foreach ($customers as $customer)
                <tr>
                    <td>{{ $customer->id }}</td>
                    <td> {{ dateFormat($customer->created_at, DISPLAY_DATETIME) }}</td>
                    <td class="text-capitalize">
                        <strong>{{ $customer->full_name }}</strong>
                    </td>
                    {{-- <td class="">
                        {{ $customer->email }}
                    </td> --}}
                    <td class="text-capitalize">

                        {{ $customer->dial_code }}
                        {{ $customer->mobile_number }}
                    </td>
                    {{-- <td>

                        <span
                            class="badge
                    {{ $customer->status === 'active' ? 'bg-label-success' : 'bg-label-danger' }}
                     
                      me-1">{{ $customer->status }}</span>
                    </td> --}}
                    <td>
                        @if ($customer->deleted_at)
                            <span class="badge bg-danger">@lang('message.customer_deleted')</span>
                        @else
                            {!! statusText($customer->status) !!}
                        @endif

                    </td>

                    <td>
                        @if (!$customer->deleted_at)
                            @if (
                                $authUser->hasPermissionTo('edit - customer') ||
                                    $authUser->hasPermissionTo('delete - customer') ||
                                    $authUser->id == 1)
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        @if ($authUser->hasPermissionTo('edit - customer') || $authUser->id == 1)
                                            <a class="dropdown-item"
                                                href="{{ route('admin.customer.edit', $customer->id) }}"><i
                                                    class="bx bx-edit-alt me-1"></i> @lang('message.customer_list_edit')</a>
                                        @endif
                                        {{-- <a href="#" onclick="if(confirm('Are you sure you want to delete this contact?')) { document.getElementById('delete-form').submit(); }">Delete</a> --}}
                                        @if ($authUser->hasPermissionTo('delete - customer') || $authUser->id == 1)
                                            <button class="dropdown-item delete-btn"
                                                data-url="{{ route('admin.customer.destroy', $customer->id) }}"
                                                data-id="{{ $customer->id }}" data-type="customer"><i
                                                    class="bx bx-trash me-1"></i>
                                                @lang('message.customer_list_delete')</button>
                                        @endif
                                        {{-- send message --}}
                                        <button type="button" class="dropdown-item send-message-btn"
                                            data-bs-toggle="modal" data-bs-target="#sendMessage"
                                            data-bs-whatever="sendMessage" data-name="{{ $customer->full_name }}"
                                            data-dialCode="{{ $customer->dial_code }}"
                                            data-mobileNumber="{{ $customer->mobile_number }}"
                                            data-customerId="{{ $customer->id }}">
                                            <i class="far fa-paper-plane"></i>
                                            Send Message
                                        </button>
                                    </div>
                                </div>
                            @endif
                        @endif

                    </td>
                </tr>



        </tbody>
    @endforeach
    <tfoot>
        <tr>
            <td class="" colspan="6">
                <div class="mt-2 d-flex mb-2">
                    <div class="col-sm-6">
                        <div class="" id="records">{!! pageInfo($customers) !!}</div>
                    </div>
                    <div class="col-sm-6">
                        <div class="">
                            {!! $customers->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </tfoot>
@else
    {{-- <tbody>
        <tr>
            <td class="alert alert-danger text-center" colspan="7">No Record Found!</td>
        </tr>
    </tbody> --}}
    @endif
</table>
<div class="modal fade" id="sendMessage" tabindex="-1" aria-labelledby="sendMessageLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendMessageLabel">New message</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" class="ajaxSubmit" data-form-type="send-message"
                action="{{ route('admin.customer.sendMessage') }}">
                @csrf
                <div class="modal-body">


                    <div class="mb-3">
                        <h6 class="mb-2">Recipient Info:</h6>
                        <p class="text-uppercase  mb-0 pl-2" id="recipient-name"></p>
                        <p class="text-uppercase pl-2" id="recipient-number"></p>
                    </div>
                    <div class="mb-3">
                        <label for="message-text" class="col-form-label">Message:</label>
                        <textarea class="form-control" name="message" id="message-text"></textarea>
                    </div>
                    <input type="hidden" id="dial_code" name="dial_code" value="">
                    <input type="hidden" id="mobile_number" name="mobile_number" value="">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Send message</button>
                </div>
            </form>
        </div>
    </div>
</div>
