@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Hoverable Table rows -->
            <div class="card px-4">

                @if (session('success'))
                    <div class="alert alert-success pt-2">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger pt-2">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="row mt-4 mb-4">
                    <div class="col-sm-8">
                        <h3 class=" text-dark">@lang('message.customer_list')</h3>
                    </div>



                    <div class="col-sm-4 ms-auto">
                        <div class="d-flex gap-3">
                            <div class="input-group input-group-merge">
                                <span id="basic-icon-default-fullname2" class="input-group-text">
                                    <i class="bx bx-search-alt"></i>
                                </span>

                                <input type="text" id="search" class="form-control" name="keyword"
                                    placeholder="Search">
                            </div>

                            <button type="button" class="btn btn-icon btn-info" data-bs-toggle="offcanvas"
                                href="#filterPanel" role="button" aria-controls="filterPanel">
                                <i class="bx bx-filter"></i>
                            </button>
                        </div>

                        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel" aria-labelledby="filterPanel"
                            aria-modal="true" role="dialog">
                            <div class="offcanvas-header border-bottom">
                                <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                    @lang('message.apply_filter')
                                </h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>

                            <div class="offcanvas-body p-0" id="form-filter">
                                <div class="acitivity-timeline p-4">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"> @lang('message.per_page')</label>
                                            <select id="per_page" name="" class="form-select w-auto select2">
                                                @foreach (perPage() as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if (request()->routeIs('admin.customer.index'))
                                            <input type="hidden" id="pageUrl"
                                                value="{{ route('admin.customer.index') }}">
                                        @endif


                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"> @lang('message.status')</label>
                                            <select id="status_filter" class="form-select w-auto select2" name="status">
                                                @foreach (statusFilter(true) as $key => $value)
                                                    <option value="{{ $key }}">
                                                        {{ $value }}</option>
                                                @endforeach

                                            </select>
                                        </div>

                                        <div class="col-md-12 mt-2">
                                            <button id="applyFilter" type="submit"
                                                class="filter-btn btn btn-info btn-border me-1">
                                                <i class="bx bx-check"></i> @lang('message.apply_filter')</button>
                                            </button>
                                            <a href="" class="btn btn-outline-secondary mt-2">
                                                <i class="bx bx-refresh"></i> @lang('message.clear')
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="pagination-table">
                            @include('admin.customer.pagination')
                        </div>
                    </div>
                </div>

            </div>
            <!--/ Hoverable Table rows -->
        </div>
        <!-- / Content -->
    @endsection
