@extends('admin.layouts.main')
@section('title', 'Edit Customer')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->

        <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Basic Layout -->
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="mb-0 text-dark text-uppercase">@lang('message.edit_customer')</h4>

                            </div>
                            <div class="card-body">


                                <form action="{{ route('admin.customer.update', $customer->id) }}" class="ajaxSubmit"
                                    id="ajaxSubmit" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-fullname">@lang('message.full_name')</label>
                                                <input type="text"
                                                    class="form-control @error('full_name') is-invalid @enderror"
                                                    id="basic-default-fullname"
                                                    value="{{ old('full_name', $customer->full_name) }}" name="full_name" />
                                                @error('full_name')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label d-block"
                                                    for="basic-default-phone">@lang('message.customer_list_mobile')</label>
                                                <input type="tel" id="phone"
                                                    class="w-100 form-control  @error('mobile_number') is-invalid @enderror"
                                                    name="mobile_number"
                                                    value="{{ old('mobile_number', $customer->mobile_number) }}" />
                                                @error('mobile_number')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                                <input type="hidden" name="dial_code" id="dial_code"
                                                    value="{{ $customer->dial_code }}">
                                                <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                                    value="{{ $customer->dial_code_iso }}">
                                            </div>

                                        </div>
                                        {{-- <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-email">@lang('message.customer_list_email')</label>

                                                <input type="text" name="email" id="basic-default-email"
                                                    class=" form-control @error('email') is-invalid @enderror"
                                                    aria-label="john.doe" value="{{ old('email', $customer->email) }}"
                                                    aria-describedby="basic-default-email2" />

                                                @error('email')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror


                                            </div>


                                        </div> --}}

                                        {{-- <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-password">@lang('message.password')</label>
                                                <input type="text" name="password" class="form-control" id="password"
                                                    value="" />

                                            </div>

                                        </div> --}}

                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-image">@lang('message.image')</label>
                                                <input type="file"
                                                    class="form-control @error('image') is-invalid @enderror" name="image"
                                                    id="image">
                                                @error('image')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                                <label for="" class="pt-2">Current Image</label>
                                                <div class="reside image">

                                                    @if (empty($customer->image))
                                                        <img width='100' src="{{ asset(USER_DEFAULT_IMG_PATH) }}"
                                                            class="img-fluid" alt="default image">
                                                    @else
                                                        <img width='100'
                                                            src="{{ asset(USER_UPLOADED_IMG_PATH . $customer->image) }}"
                                                            class="img-fluid" alt="image">
                                                    @endif

                                                </div>
                                            </div>

                                        </div>
                                        {{-- <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="description">@lang('message.description')</label>
                                                <textarea name="description" rows ="4" id="description" class="form-control">{{ old('description', $customer->description) }}</textarea>
                                            </div>
                                        </div> --}}
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="country">@lang('message.country')</label>
                                                <select id="country"
                                                    class="form-select @error('country') is-invalid @enderror"
                                                    name="country_id">
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ old('country', $customer->country_id) === $country->id ? 'selected' : '' }}>
                                                            {{ $country->name }}
                                                        </option>
                                                    @endforeach



                                                </select>
                                                @error('country')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>

                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="state">@lang('message.state')</label>
                                                <select id="state"
                                                    class="form-select @error('state') is-invalid @enderror"
                                                    name="state_id">
                                                    <option value="">Select State</option>

                                                </select>
                                                @error('state')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>


                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="city">@lang('message.city')</label>
                                                <select id="city"
                                                    class="form-select @error('city') is-invalid @enderror" name="city_id">
                                                    <option value="">Select City</option>

                                                </select>
                                                @error('city')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-message">@lang('message.address')</label>
                                                <textarea name="address" id="basic-default-address" class="form-control">{{ $customer->address }}</textarea>

                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="zip_code">@lang('message.zip_code')</label>
                                                <input type="text"
                                                    class="form-control @error('zip_code') is-invalid @enderror"
                                                    id="zip_code" value="{{ old('zip_code', $customer->zip_code) }}"
                                                    name="zip_code" />
                                                @error('zip_code')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-status">@lang('message.status')</label>
                                                <select class="form-select @error('status') is-invalid @enderror"
                                                    name="status">
                                                    <option value="active"
                                                        {{ $customer->status == 'active' ? 'selected' : '' }}>Active
                                                    </option>
                                                    <option value="inactive"
                                                        {{ $customer->status == 'inactive' ? 'selected' : '' }}>
                                                        Inactive</option>

                                                </select>
                                                @error('status')
                                                    <p class="invalid-feedback">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="submit-btn-outer mt-4">
                                        <button type="submit" class="btn btn-primary">@lang('message.update_details')</button>
                                    </div>
                            </div>





                            </form>


                        </div>


                    </div>
                    <div class="col-lg-4">
                        {{-- customer stats --}}
                        @if ($customer->successful_deals_count > 0 || $customer->bad_deals_count > 0 || $totalDeals > 0)
                            <div class="p-4 card mb-4">
                                <div class=" d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0 text-dark text-uppercase"> @lang('message.customer_stats')</h5>

                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        @if ($totalDeals > 0)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="successful_deals_count">@lang('message.total_deals')</label>
                                                <p class="text-capitalize">

                                                    {{ $totalDeals }}


                                                </p>


                                            </div>
                                        @endif

                                        @if ($customer->successful_deals_count > 0)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="successful_deals_count">@lang('message.successful_deals_count')</label>
                                                <p class="text-capitalize">

                                                    {{ $customer->successful_deals_count }}
                                                    @if ($customer->rank)
                                                        <span class="text-success">
                                                            ( @lang('message.rank') : {{ $customer->rank->getTitleByLang() }})
                                                            {!! getRankIcons($customer->rank->icon, $customer->rank->icon_type, $customer->rank->icon_count) !!}
                                                        </span>
                                                    @endif

                                                </p>


                                            </div>
                                        @endif
                                        @if ($customer->bad_deals_count)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="bad_deals_count">@lang('message.total_bad_deals_count')</label>
                                                <p class="text-capitalize">

                                                    {{ $customer->bad_deals_count }}


                                                </p>


                                            </div>
                                        @endif
                                        @if ($customer->bad_deals_after_activation)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="bad_deals_count">@lang('message.bad_deals_after_activation')</label>
                                                <p class="text-capitalize">

                                                    {{ $customer->bad_deals_after_activation }}


                                                </p>


                                            </div>
                                        @endif
                                        @if ($customer->last_inactivated_at)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="bad_deals_count">@lang('message.last_inactivated_at')</label>
                                                <p class="text-capitalize">

                                                    {{ date(DISPLAY_DATE, strtotime($customer->last_inactivated_at)) }}


                                                </p>


                                            </div>
                                        @endif

                                        @if ($customer->last_reactivated_at)
                                            <div class="my-3 pt-2">
                                                <label class="form-label d-block"
                                                    for="bad_deals_count">@lang('message.last_reactivated_at')</label>
                                                <p class="text-capitalize">

                                                    {{ date(DISPLAY_DATE, strtotime($customer->last_reactivated_at)) }}


                                                </p>


                                            </div>
                                        @endif


                                    </div>

                                </div>
                            </div>
                        @endif
                        {{-- ID images --}}
                        @if ($customer->id_front_side && $customer->id_back_side)
                            <div class="p-4 card mb-4">
                                <div class=" d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0 text-dark text-uppercase"> @lang('message.ID_proofs')</h5>

                                </div>

                                <div class="row">

                                    <div class="col-sm-12">

                                        <div class="my-3 pt-2">
                                            @if ($customer->id_front_side)
                                                <div>
                                                    <a data-fancybox="gallery" class="id-proof shdw"
                                                        href="{{ asset(CUSTOMER_PATH . '/' . $customer->id_front_side) }}"
                                                        target="_blank">
                                                        <img class="id-img img-fluid"
                                                            src="{{ asset(CUSTOMER_PATH . '/' . $customer->id_front_side) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @endif
                                            @if ($customer->id_back_side)
                                                <div class="pt-3">
                                                    <a data-fancybox="gallery" class="id-proof shdw"
                                                        href="{{ asset(CUSTOMER_PATH . '/' . $customer->id_back_side) }}"
                                                        target="_blank">
                                                        <img class="id-img img-fluid"
                                                            src="{{ asset(CUSTOMER_PATH . '/' . $customer->id_back_side) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @endif
                                            </p>
                                        </div>
                                    </div>

                                </div>


                            </div>
                        @endif
                        {{-- bank details card --}}
                        <div class="p-4 card mb-4">
                            <div class=" d-flex justify-content-between align-items-center">
                                <h5 class="mb-0 text-dark text-uppercase"> @lang('message.bank_details')</h5>

                            </div>

                            <div class="row">
                                <div class="col-sm-12">

                                    <div class="my-3 pt-2">
                                        <label class="form-label d-block"
                                            for="account_holder_name">@lang('message.account_holder_name')</label>
                                        <p class="text-capitalize">
                                            @if ($customer->account_holder_name != null)
                                                {{ $customer->account_holder_name }}
                                            @else
                                                <span class="text-danger">@lang('message.empty_record')</span>
                                            @endif

                                        </p>


                                    </div>






                                </div>
                                <div class="col-sm-12">




                                    <div class="my-3">
                                        <label class="form-label" for="account_number">@lang('message.account_number')</label>
                                        <p>
                                            @if ($customer->account_number != null)
                                                {{ $customer->account_number }}
                                            @else
                                                <span class="text-danger">@lang('message.empty_record')</span>
                                            @endif

                                        </p>


                                    </div>




                                </div>
                                <div class="col-sm-12">



                                    <div class="my-3 ">
                                        <label class="form-label" for="bank_name">@lang('message.bank_name')</label>
                                        <p class="text-capitalize">
                                            @if ($customer->bank_name != null)
                                                {{ $customer->bank_name }}
                                            @else
                                                <span class="text-danger">@lang('message.empty_record')</span>
                                            @endif

                                        </p>

                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
        <!-- / Content -->




    @endsection

    @section('top_scripts')
        <script>
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            let initial_country = '{{ strtolower($customer->dial_code_iso) }}';
            //get sates and cities
            const getStatesUrl = "{{ url('admin/get-states') }}/"
            const getCitiesUrl = "{{ url('admin/get-cities') }}/"
            let preselectState = "{{ old('state', $customer->state_id) }}"
            let preselectCity = "{{ old('city', $customer->city_id) }}"
            //console.log(preselectCity)

            function loadStates(countryId) {
                $.get(getStatesUrl + countryId, function(states) {
                    let preselectState = "{{ old('state', $customer->state_id) }}"
                    //console.log(states)
                    let stateOptions = '<option value="">Select State</option>';
                    states.forEach(state => {
                        const selected = (state.id == preselectState) ? 'selected' : '';
                        stateOptions += `<option value="${state.id}" ${selected}>${state.name}</option>`;
                    });
                    $('#state').html(stateOptions);
                    $('#state').trigger('change');
                });
            }

            function loadCities(stateId) {
                $.get(getCitiesUrl + stateId, function(cities) {
                    let preselectCity = "{{ old('city', $customer->city_id) }}"
                    let cityOptions = '<option value="">Select City</option>';
                    cities.forEach(city => {
                        const selected = (city.id == preselectCity) ? 'selected' : '';
                        cityOptions += `<option value="${city.id}" ${selected}>${city.name}</option>`;
                    });
                    $('#city').html(cityOptions);
                });
            }
            //initial load
            const countryId = $('#country').val();
            if (countryId) {
                loadStates(countryId);
            }
            $('#country').change(function() {
                const countryId = $(this).val();
                preselectState = "";
                preselectCity = "";
                $('#city').html('<option value="">Select City</option>')
                if (countryId) {
                    loadStates(countryId);
                } else {
                    $('#state').html('<option>Select State</option>');
                }
            });
            $('#state').change(function() {
                let stateId = $(this).val();
                preselectCity = "";
                if (stateId) {
                    loadCities(stateId);
                } else {
                    $('#city').html('<option value="">Select City</option>');
                }
            });
        </script>
    @endsection
