@extends('admin.layouts.main')
@section('title', 'Customer Rank')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row ">
                <div class="col-12">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4 pt-4">

                        @if (session('success'))
                            <div class="alert alert-success pt-2">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger pt-2">
                                {{ session('error') }}
                            </div>
                        @endif



                        <div class="mt-5 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">@lang('message.customer_rank_list')</h3>

                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class=" dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>

                                                <th>
                                                    @lang('message.title')
                                                </th>

                                                <th>
                                                    @lang('message.min_successful_deals')
                                                </th>

                                                <th>
                                                    @lang('message.icon_or_image')
                                                </th>

                                                <th>
                                                    @lang('message.icon_type')
                                                </th>

                                                <th>
                                                    @lang('message.icon_count')
                                                </th>

                                                <th> @lang('message.actions')</span></th>
                                            </tr>
                                        </thead>
                                        @if (isset($ranks) && count($ranks) > 0)
                                            <tbody class="table-border-bottom-0">

                                                @foreach ($ranks as $rank)
                                                    <tr>

                                                        <td class="text-capitalize">
                                                            {{ $rank->getTitleByLang() }}</td>
                                                        <td class="text-capitalize">{{ $rank->min_successful_deals }}</td>
                                                        <td class="text-capitalize">
                                                            @if (!empty($rank->icon))
                                                                <img width="30" class=""
                                                                    src="{{ asset(RANK_ICONS . '/' . $rank->icon) }}"
                                                                    alt="">
                                                            @else
                                                                <p class="text-muted">@lang('message.no_icon_available')</p>
                                                            @endif
                                                        </td>
                                                        <td class="text-capitalize">{{ $rank->icon_type }}</td>
                                                        <td class="text-capitalize">{{ $rank->icon_count }}</td>

                                                        <td>
                                                            @if ($authUser->hasPermissionTo('edit - customer rank') || $authUser->id == 1)
                                                                <div class="d-flex">


                                                                    <a class="btn-role"
                                                                        href="{{ route('admin.customerRank.edit', $rank->id) }}">
                                                                        <i class="bx bx-edit"></i></a>


                                                                    {{-- <button class="delete-btn btn-role"
                                                                    data-url="{{ route('admin.role.destroy', $rank->id) }}"
                                                                    data-id="{{ $rank->id }}"><i
                                                                        class="bx bx-trash me-1"></i>
                                                                </button> --}}


                                                                </div>
                                                            @endif
                                                        </td>
                                                    </tr>



                                            </tbody>
                                        @endforeach
                                    @else
                                        <tbody>
                                            <tr>
                                                <td colspan ="3" class="text-danger">No Rank created</td>
                                            </tr>
                                        </tbody>
                                        @endif
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    @endsection
