@extends('admin.layouts.main')
@section('title', 'Edit Customer Rank')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="col-lg-12">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.edit_customer_rank')
                    </h5>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.customerRank.update', $rank->id) }}" id="ajaxSubmit"
                                    class="ajaxSubmit" enctype="multipart/form-data">

                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-12">
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.title')
                                                    (@lang('message.english'))</label>
                                                <div class="col-md-10">
                                                    <input type="text" class="form-control" id="title_en"
                                                        value="{{ old('title_en', $rank->title_en) }}" name="title_en" />

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.title')
                                                    (@lang('message.spanish'))</label>
                                                <div class="col-md-10">
                                                    <input type="text" class="form-control" id="title_es"
                                                        value="{{ old('title_es', $rank->title_es) }}" name="title_es" />

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.min_successful_deals')</label>
                                                <div class="col-md-10">
                                                    <input type="number" min="1" class="form-control"
                                                        id="min_successful_deals"
                                                        value="{{ old('min_successful_deals', $rank->min_successful_deals) }}"
                                                        name="min_successful_deals" />

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.icon_type')</label>
                                                <div class="col-md-10">
                                                    <select class="form-select" name="icon_type" id="icon_type">
                                                        @foreach (rankFilter() as $value => $label)
                                                            <option value="{{ $value }}"
                                                                {{ $value == old('icon_type', $rank->icon_type) ? 'selected' : '' }}>
                                                                {{ $label }}</option>
                                                        @endforeach
                                                    </select>

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.icon_count')</label>
                                                <div class="col-md-10">
                                                    <input type="number" min="1" max="5" class="form-control"
                                                        id="icon_count" value="{{ old('icon_count', $rank->icon_count) }}"
                                                        name="icon_count" />
                                                </div>
                                            </div>

                                            <div class="row my-3">
                                                <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                    @lang('message.icon_or_image')
                                                </label>
                                                <div class="col-md-10">
                                                    <input type="file" class="form-control" name="file"
                                                        id="file">

                                                    @error('image')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                    <div class="existing-image py-4">

                                                        @if (!empty($rank->icon))
                                                            <img width="30" class=""
                                                                src="{{ asset(ADMIN_PATH . '/' . $rank->icon) }}"
                                                                alt="">
                                                        @else
                                                            <p class="text-muted">@lang('message.no_icon_available')</p>
                                                        @endif

                                                    </div>

                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class=" offset-md-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bx bx-check"></i> @lang('message.update_details')
                                        </button>
                                    </div>
                            </div>

                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
