<table class="dataTable dt-responsive table table-hover display align-middle mb-0">
    <thead>
        <tr>
            <th>@lang('message.s_no')</span></th>

            <th><span>
                    @lang('message.image') / @lang('message.video')

                </span></th>
            <th><span class="sortable" data-sort="status" data-order="asc">
                    @lang('message.status') <i id="sort-icon-status" class="bx bx-sort"></i>

                </span></th>


            <th>@lang('message.actions')</span></th>
        </tr>
    </thead>
    @if (isset($banners) && count($banners) > 0)
        <tbody class="table-border-bottom-0">
            @php
                $i = !empty($banners) ? pageIndex($banners) : 1;
            @endphp
            @foreach ($banners as $banner)
                <tr>
                    <td>{{ $i++ }}</td>

                    <td class="text-capitalize">
                        @if ($banner->file_type == 'image')
                            <a data-fancybox="gallery" class="shdw"
                                href="{{ asset(BANNER_PATH . '/' . $banner->image) }}" target="_blank">
                                <img width="" class="media-item"
                                    src="{{ asset(BANNER_PATH . '/' . $banner->image) }}" alt="">
                            </a>
                        @elseif ($banner->file_type == 'video')
                            <a class="shdw" data-fancybox="gallery"
                                href="{{ asset(BANNER_PATH . '/' . $banner->image) }}">
                                <img width="" class="media-item"
                                    src="{{ asset(BANNER_PATH . '/' . $banner->video_poster) }}" alt="">
                            </a>
                        @endif


                        {{-- src="{{ asset(USER_UPLOADED_IMG_PATH . $customer->image) }}" --}}
                    </td>


                    {{-- <td>

                        <span
                            class="badge
                    {{ $customer->status === 'active' ? 'bg-label-success' : 'bg-label-danger' }}
                     
                      me-1">{{ $customer->status }}</span>
                    </td> --}}
                    <td>
                        {!! statusText($banner->status) !!}
                    </td>

                    <td>
                        @if ($authUser->hasPermissionTo('edit - banner') || $authUser->hasPermissionTo('delete - banner') || $authUser->id == 1)
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                    data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @if ($authUser->hasPermissionTo('edit - banner') || $authUser->id == 1)
                                        <a class="dropdown-item" href="{{ route('admin.banner.edit', $banner->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> @lang('message.customer_list_edit')</a>


                                        {{-- <a href="#" onclick="if(confirm('Are you sure you want to delete this contact?')) { document.getElementById('delete-form').submit(); }">Delete</a> --}}
                                    @endif
                                    @if ($authUser->hasPermissionTo('delete - banner') || $authUser->id == 1)
                                        <button class="dropdown-item delete-btn"
                                            data-url="{{ route('admin.banner.destroy', $banner->id) }}"
                                            data-id="{{ $banner->id }}"><i class="bx bx-trash me-1"></i>
                                            @lang('message.customer_list_delete')</button>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </td>
                </tr>



        </tbody>
    @endforeach
    <tfoot>
        <tr>
            <td class="" colspan="4">
                <div class="mt-2 d-flex mb-2">
                    <div class="col-sm-6">
                        <div class="" id="records">{!! pageInfo($banners) !!}</div>
                    </div>
                    <div class="col-sm-6">
                        <div class="">
                            {!! $banners->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </tfoot>
@else
    {{-- <tbody>
        <tr>
            <td class="alert alert-danger text-center" colspan="4">No Record Found!</td>
        </tr>
    </tbody> --}}
    @endif
</table>
