@extends('admin.layouts.main')
@section('title', 'Banners')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Hoverable Table rows -->
            <div class="card px-4 ">


                <h3 class="mt-4 text-dark">@lang('message.banner_list')</h3>
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif
                <hr>
                <div class="">

                    <div
                        class="my-3
                     @if ($authUser->hasPermissionTo('add - banner') || $authUser->id == 1) d-flex justify-space-between
                    @else
                    text-right @endif">
                        @if ($authUser->hasPermissionTo('add - banner') || $authUser->id == 1)
                            <div class="">
                                <a href="{{ route('admin.banner.create') }}" class="btn btn-primary"><i
                                        class='bx bx-plus-circle'></i> @lang('message.create')</a>
                            </div>
                        @endif

                        <div class="">



                            <button type="button" class="btn btn-icon btn-info" data-bs-toggle="offcanvas"
                                href="#filterPanel" role="button" aria-controls="filterPanel">
                                <i class="bx bx-filter"></i>
                            </button>


                            <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel"
                                aria-labelledby="filterPanel" aria-modal="true" role="dialog">
                                <div class="offcanvas-header border-bottom">
                                    <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                        @lang('message.apply_filter')
                                    </h5>
                                    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                        aria-label="Close"></button>
                                </div>

                                <div class="offcanvas-body p-0" id="form-filter">
                                    <div class="acitivity-timeline p-4">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">@lang('message.per_page')</label>
                                                <select id="per_page" name="" class="form-select w-auto select2">
                                                    @foreach (perPage() as $key => $value)
                                                        <option value="{{ $key }}">{{ $value }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @if (request()->routeIs('admin.banner.index'))
                                                <input type="hidden" id="pageUrl"
                                                    value="{{ route('admin.banner.index') }}">
                                            @endif


                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">@lang('message.deal_status')</label>
                                                <select id="status_filter" class="form-select w-auto select2"
                                                    name="status">
                                                    @foreach (statusFilter(true) as $key => $value)
                                                        <option value="{{ $key }}">
                                                            {{ $value }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="col-md-12 mt-2">
                                                <button id="applyFilter" type="submit"
                                                    class="filter-btn btn btn-info btn-border me-1">
                                                    <i class="bx bx-check"></i>@lang('message.apply_filter')</button>
                                                </button>
                                                <a href="" class="btn btn-outline-secondary mt-2">
                                                    <i class="bx bx-refresh"></i> @lang('message.clear')
                                                </a>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="pagination-table">
                            @include('admin.banners.pagination')
                        </div>
                    </div>
                </div>

            </div>
            <!--/ Hoverable Table rows -->
        </div>
        <!-- / Content -->
    @endsection
