@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="col-lg-12">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.edit_banner')
                    </h5>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.banner.update', $banner->id) }}" id="ajaxSubmit"
                                    class="ajaxSubmit" enctype="multipart/form-data">

                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">


                                        <div class="col-12">

                                            <div class="row my-3">
                                                <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                    @lang('message.image')
                                                </label>
                                                <div class="col-md-10">
                                                    <input type="file"
                                                        class="form-control @error('image') is-invalid @enderror"
                                                        name="file" id="file">

                                                    @error('image')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                    <div class="existing-image py-4">
                                                        @if ($banner->file_type == 'image')
                                                            <img width="" class="media-item"
                                                                src="{{ asset(BANNER_PATH . '/' . $banner->image) }}"
                                                                alt="">
                                                        @elseif ($banner->file_type == 'video')
                                                            <img width="" class="media-item"
                                                                src="{{ asset(BANNER_PATH . '/' . $banner->video_poster) }}"
                                                                alt="">
                                                        @endif

                                                        @error('image')
                                                            <p class="invalid-feedback">{{ $message }}</p>
                                                        @enderror
                                                    </div>

                                                </div>

                                            </div>

                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.status')</label>
                                                <div class="col-md-10">
                                                    <select class="form-select" name="status" id="status">
                                                        @foreach (statusFilter() as $key => $value)
                                                            <option value="{{ $key }}"
                                                                {{ $key == old('status', $banner->status) ? 'selected' : '' }}>
                                                                {{ $value }}</option>
                                                        @endforeach

                                                    </select>
                                                    <input type="hidden" name="video_poster" id="video_poster"
                                                        class="video_poster">
                                                </div>
                                            </div>



                                        </div>
                                    </div>


                                    <div class=" offset-md-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bx bx-check"></i> @lang('message.update_details')
                                        </button>
                                    </div>
                            </div>

                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
    @section('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const fileInput = document.getElementById("file"); // your input[type=file]
                const video = document.createElement("video");
                video.style.display = "none";
                document.body.appendChild(video);

                const hiddenPosterInput = document.getElementById("video_poster");

                fileInput.addEventListener("change", function() {
                    const file = fileInput.files[0];
                    if (!file) return;

                    const fileExtension = file.name.split('.').pop().toLowerCase();
                    const videoExtensions = ['mp4', 'webm', 'ogg'];

                    if (videoExtensions.includes(fileExtension)) {
                        const videoURL = URL.createObjectURL(file);
                        video.src = videoURL;

                        video.onloadeddata = () => {
                            video.currentTime = 1;
                        };

                        video.onseeked = () => {
                            const canvas = document.createElement("canvas");
                            canvas.width = video.videoWidth;
                            canvas.height = video.videoHeight;

                            const ctx = canvas.getContext("2d");
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

                            const base64Image = canvas.toDataURL("image/jpeg", 0.8); // 80% quality
                            hiddenPosterInput.value = base64Image;
                        };
                    } else {
                        hiddenPosterInput.value = ''; // Clear if not video
                    }
                });
            });
        </script>
    @endsection
