/* #sticky Header
================================================== */

const navbar = document.getElementById('mainNavbar');
const stickyScrollPoint = navbar.offsetTop;

window.addEventListener('scroll', () => {
  if (window.scrollY > stickyScrollPoint) {
    navbar.classList.add('sticky');
  } else {
    navbar.classList.remove('sticky');
  }
});






$(document).ready(function () {

  $(function () {

    $(document).on('scroll', function () {

      if ($(window).scrollTop() > 100) {
        $('.scroll-top-wrapper').addClass('show');
      } else {
        $('.scroll-top-wrapper').removeClass('show');
      }
    });

    $('.scroll-top-wrapper').on('click', scrollToTop);
  });

  function scrollToTop() {
    verticalOffset = typeof (verticalOffset) != 'undefined' ? verticalOffset : 0;
    element = $('body');
    offset = element.offset();
    offsetTop = offset.top;
    $('html, body').animate({ scrollTop: offsetTop }, 500, 'linear');
  }

});
//intialize intel
if ($('#phone').length > 0) {
  document.addEventListener("DOMContentLoaded", function () {
    var input = document.querySelector("#phone");

    var iti = window.intlTelInput(input, {
      separateDialCode: true, // Displays country code separately
      // preferredCountries: ["us", "gb", "in"], // Preferred countries at top
      initialCountry: (typeof initial_country !== 'undefined') ? initial_country : "mx",

      geoIpLookup: function (callback) {
        fetch("https://ipinfo.io?token=YOUR_TOKEN")
          .then(response => response.json())
          .then(data => callback(data.country))
          .catch(() => callback("us"));
      },
    });

    // Listen for changes and update hidden inputs
    input.addEventListener("countrychange", function () {
      var countryData = iti.getSelectedCountryData();
      document.querySelector("#dial_code").value = '+' + countryData.dialCode;
      document.querySelector("#dial_code_iso").value = countryData.iso2;
    });
  });
}
// Website Contact Form Submit
function submitContactForm(form) {
  var formData = new FormData(form[0]);

  $.ajax({
    url: form.attr('action'),
    method: "POST",
    data: formData,
    processData: false,
    contentType: false,
    beforeSend: function () {
      // Optional: show a loader/spinner
      Swal.fire({
        title: window.translation.sending,
        text: window.translation.please_wait,
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });
    },
    success: function (response) {
      Swal.close();

      if (response.status === true && response.statusCode === 200) {
        Swal.fire({
          icon: 'success',
          title: window.translation.message_sent,
          text: response.message,
        }).then(() => {
          form[0].reset(); // clear form
        });
      } else {
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: response.message || window.translation.something_wrong,
        });
      }
    },
    error: function (xhr) {
      Swal.close();
      let res = xhr.responseJSON;

      if (res && res.statusCode === 400) {
        $.each(res.message, function (field, messages) {
          var fieldElement = form.find('[name="' + field + '"]');
          if (fieldElement.length == 1) {
            fieldElement.addClass('is-invalid');
            fieldElement.parent().append('<p class="invalid-feedback">' + messages.join(', ') + '</p>');
          }
          else {
            var fieldElement1 = form.find('[name="' + field + '[]"]');

            //console.log(form.html());
            if (fieldElement1 == 1) {
              fieldElement.addClass('is-invalid');
              fieldElement.parent().append('<p class="invalid-feedback">' + messages.join(', ') + '</p>');
            }
            else {
              fieldElement1.parents('#' + field).append('<p class="invalid-feedback d-block text-danger">' + messages.join(', ') + '</p>');
            }

          }

        });
      } else {
        Swal.fire({
          icon: 'error',
          title: window.translation.server_error,
          text: res?.message || window.translation.try_again,
        });
      }
    }
  });
}