$(document).ready(function () {
    //display by default records after page load

    let dangerColor = '#ea1c1c';
    let greenColor = '#9EC600';

    function showLoader() {
        $('#loader').show();
    }

    function hideLoader() {
        $('#loader').hide();
    }

    $(document).on('submit', '.ajaxSubmit', function (event) {
        event.preventDefault(); // Prevent default form submission
        var form = $(this); // Get the current form
        var formAction = form.attr('action');

        if (formAction.includes("/deal/") && formAction.includes("/status")) {
            Swal.fire({
                title: window.translation.areYouSure,
                text: window.translation.updateQuestion,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: window.translation.yesUpdate
            }).then((result) => {
                if (result.isConfirmed) {
                    submitForm(form);
                }
            });
        }
        else if (formAction.includes("/deal/") && formAction.includes("/mark-paid")) {
            Swal.fire({
                title: window.translation.markPaidTitle,
                text: window.translation.markPaidText,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#10b981',
                cancelButtonColor: '#d33',
                confirmButtonText: window.translation.yesMarkPaid
            }).then((result) => {
                if (result.isConfirmed) {
                    submitForm(form);
                }
            });
        }
        else {

            submitForm(form);

        }
    });
    if ($('#pageUrl').length > 0) {
        fetchData();
    }



    // Sorting Click Event
    $(document).on('click', '.sortable', function () {
        let sortBy = $(this).data('sort'); // Get column
        let currentOrder = $(this).attr('data-order') || 'asc'; // Get current order, default 'asc'
        let newOrder = (currentOrder === 'asc') ? 'desc' : 'asc'; // Toggle order

        // Update sorting icons dynamically
        updateSortingIcons(sortBy, newOrder);

        // Update data-order attribute
        $(this).attr('data-order', newOrder);

        // Fetch data with new sorting order
        fetchData(1, sortBy, newOrder);
    });

    function fetchData(page = 1, sortBy = '', sortOrder = '') {
        let pageUrl = $('#pageUrl').val();
        if (!pageUrl) {
            console.error("Error: #pageUrl is not defined.");
            return;
        }

        let perPage = $('#per_page').val();
        let keyword = $('#search').val();
        let paymentFilter = $('#payment_status').val();
        let closureType = $('#closure_type').val();




        let data = {
            per_page: perPage,
            keyword: keyword,
            sort_by: sortBy,
            sort_order: sortOrder,
            payment_status: paymentFilter,
            closure_type: closureType,
        };

        let urlParams = new URLSearchParams();
        urlParams.append("page", page);
        if (sortBy) urlParams.append("sort_by", sortBy);
        if (sortOrder) urlParams.append("sort_order", sortOrder);

        if (window.location.pathname.includes("deal")) {
            let dealStatus = $('#deal_status_filter').val();
            let dealType = $('#deal_type_filter').val();
            let dateRange = $('#date').val();
            let currencyType = $('#currency_type_filter').val();

            if (dealStatus) {
                data.deal_status = dealStatus;
                urlParams.append("deal_status", dealStatus);
            }
            if (dealType) {
                data.deal_type = dealType;
                urlParams.append("deal_type", dealType);
            }
            if (dateRange) {
                data.date_range = dateRange;
                urlParams.append("date_range", dateRange);
            }
            if (currencyType) {
                data.currency_type = currencyType;
                urlParams.append("currency_type", currencyType);
            }
        }
        else {

            let status = $('#status_filter').val();
            if (status) {
                data.status = status;
                urlParams.append("status", status);
            }

        }

        let url = `${pageUrl}?${urlParams.toString()}`;

        $.ajax({
            url: url,
            type: 'get',
            data: data,
            beforeSend: function () {
                showLoader();
            },
            success: function (response) {
                $('#pagination-table').html(response.data);

                if (response.data) {

                    $('#pagination-table').find('.dataTable').DataTable({
                        searching: false,
                        paging: false,
                        ordering: false,
                        info: false,
                        language: {
                            emptyTable: "<span class='text-danger'>No records found </span>"
                        },
                        fnDrawCallback: function (oSettings) {
                            if (oSettings.fnRecordsTotal() === 0) {
                            } else {
                                $("tfoot td").show();
                            }
                        }
                    });

                    total_record = $('#pagination-table').find('.dataTable tbody tr').length;
                    $('#pagination-table').find('tfoot tr td').removeAttr('style');
                }

                $('#pagination-table').on('click', 'tr.clickable-row', function (e) {
                    if (!$(e.target).closest('.dropdown, .dropdown-toggle, .dropdown-menu, a').length) {
                        const url = $(this).data('href');
                        if (url) {
                            window.location.href = url;
                        }
                    }
                });

                hideLoader();

                if (sortBy && sortOrder) {
                    $(`.sortable[data-sort="${sortBy}"]`).attr('data-order', sortOrder);
                    updateSortingIcons(sortBy, sortOrder);
                }

                window.history.pushState(null, '', url);
            }
        });
    }


    function updateSortingIcons(sortBy, sortOrder) {
        // Reset all icons
        $('.sortable i').removeClass('bx-sort-up bx-sort-down').addClass('bx-sort');

        // Update selected column's icon
        let icon = $(`#sort-icon-${sortBy.replace('.', '_')}`);
        icon.removeClass('bx-sort').addClass(sortOrder === 'asc' ? 'bx-sort-up' : 'bx-sort-down');
    }

    // Filter & Pagination Events
    $('#applyFilter').click(function () {
        fetchData(1);
        $('#filterPanel').offcanvas('hide');
    });

    $('#search').on('keyup', function () {
        clearTimeout(this.delay);
        this.delay = setTimeout(function () {
            fetchData(1);
        }, 500);
    });

    $('#payment_status').on('change', function () {
        clearTimeout(this.delay);
        this.delay = setTimeout(function () {
            fetchData(1);
        }, 500);

    })

    $('#closure_type').on('change', function () {
        clearTimeout(this.delay);
        this.delay = setTimeout(function () {
            fetchData(1);
        }, 500);

    })



    $(document).on('click', '.pagination a', function (e) {
        e.preventDefault();
        let page = $(this).attr('href').split('page=')[1];
        fetchData(page);
    });



    // $('#myTable').DataTable();

    //delete call
    $(document).on('click', '.delete-btn', function () {
        let type = $(this).data('type');
        let text = (type === 'customer')
            ? window.translation.deleteWarningCustomer
            : window.translation.deleteWarning;


        Swal.fire({
            title: window.translation.areYouSure,
            text: text,
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: window.translation.yesDelete
        }).then((result) => {
            if (result.isConfirmed) {
                var newUrl = $(this).data('url'); // Get the correct URL from data attribute

                $.ajax({
                    url: newUrl,
                    type: 'POST', // Laravel does not handle DELETE directly via forms, so use POST
                    data: {
                        _method: 'DELETE', // Required to spoof DELETE method in Laravel
                        _token: $('meta[name="csrf-token"]').attr('content')  // CSRF token for security
                    },
                    success: function (response) {
                        if (response.status === true && response.statusCode === 200) {
                            $.toast({
                                heading: window.translation.success,
                                text: response.message,
                                icon: 'success',
                                loader: true,
                                loaderBg: greenColor,
                                afterHidden: function () {
                                    window.location.href = response.extra.redirect;
                                }
                            });
                        }


                    },
                    error: function (response) {
                        console.log(response)
                        let reqResponse = response.responseJSON;
                        if (reqResponse.statusCode === 500) {
                            $.toast({
                                heading: 'Error',
                                text: reqResponse.message,
                                icon: 'error',
                                loader: true,
                                loaderBg: dangerColor,
                                afterHidden: function () {
                                    window.location.href = reqResponse.extra.redirect;
                                }
                            });
                        }
                        console.log('Something went wrong');
                    }
                });
            }



        });
    });



    //update submitForm
    function submitForm(form) {

        //ck Editor WORKING CODE
        try {
            for (instance in CKEDITOR.instances) {
                CKEDITOR.instances[instance].updateElement();
            }
        } catch (e) {
            // print error
        }
        var formData = new FormData(form[0]); // Get form data dynamically
        $.ajax({
            url: form.attr('action'),
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                showLoader();
            },
            success: function (response) {
                hideLoader();
                $('.is-invalid').removeClass('is-invalid');
                $('.invalid-feedback').remove();

                //check if form is send message
                if (form.data('form-type') === 'send-message') {
                    //hide modal after submit
                    $('#sendMessage').modal('hide');
                    //now show sweet alert
                    Swal.fire({
                        title: response.status ? 'Success' : 'Error',
                        text: response.message,
                        icon: response.status ? 'success' : 'error',
                        confirmButtonText: 'OK'
                    });
                    return;
                }

                if (response.status === true && response.statusCode === 200) {
                    if (!response.convo) {
                        $.toast({
                            heading: window.translation.success,
                            text: response.message,
                            icon: 'success',
                            loader: true,
                            loaderBg: greenColor,
                            afterHidden: function () {
                                window.location.href = response.extra.redirect;
                            }
                        });
                    }
                    else {

                        hideLoader();
                        $("#message-input-buyer").val("");
                        $("#message-input-seller").val("");
                        loadMessages();
                    }





                }
                else if (response.statusCode === 207) {
                    $.toast({
                        text: response.message,
                        icon: 'error',
                        loader: true,
                        loaderBg: dangerColor,
                    });
                }
            },
            error: function (response) {
                hideLoader();
                let reqResponse = response.responseJSON;
                $('.is-invalid').removeClass('is-invalid');
                $('.invalid-feedback').remove();

                if (reqResponse.statusCode === 400) {
                    $.each(reqResponse.message, function (field, messages) {
                        var fieldElement = form.find('[name="' + field + '"]');
                        if (fieldElement.length == 1) {
                            fieldElement.addClass('is-invalid');
                            fieldElement.parent().append('<p class="invalid-feedback">' + messages.join(', ') + '</p>');
                        }
                        else {
                            var fieldElement1 = form.find('[name="' + field + '[]"]');

                            //console.log(form.html());
                            if (fieldElement1 == 1) {
                                fieldElement.addClass('is-invalid');
                                fieldElement.parent().append('<p class="invalid-feedback">' + messages.join(', ') + '</p>');
                            }
                            else {
                                fieldElement1.parents('#' + field).append('<p class="invalid-feedback d-block text-danger">' + messages.join(', ') + '</p>');
                            }

                        }

                    });
                    const firstInvalid = form.find('.is-invalid').first();
                    if (firstInvalid.length) {
                        $('html, body').animate({
                            scrollTop: firstInvalid.offset().top - 100 // adjust offset as needed
                        }, 500);
                    }

                }
                else if (reqResponse.statusCode === 500) {
                    $.toast({
                        heading: 'Server Error',
                        text: reqResponse.message,
                        icon: 'error',
                        loader: true,
                        loaderBg: dangerColor,
                        afterHidden: function () {
                            window.location.href = reqResponse.extra.redirect;
                        }
                    });
                }
            }
        });
    }

    //load messages after send button trigger
    function loadMessages() {
        var url = $('#get_messages_url').val();

        $.ajax({
            url: url,
            method: "GET",
            success: function (response) {
                $("#buyer-message-list").html(response.buyer_html);
                $("#seller-message-list").html(response.seller_html);
                $("#buyer-message-list, #seller-message-list").each(function () {
                    $(this).scrollTop(this.scrollHeight);
                });
            }
        });



    }
    setInterval(loadMessages, 10000);
});

//intialize intel
if ($('#phone').length > 0) {
    document.addEventListener("DOMContentLoaded", function () {
        var input = document.querySelector("#phone");

        var iti = window.intlTelInput(input, {
            separateDialCode: true, // Displays country code separately
            // preferredCountries: ["us", "gb", "in"], // Preferred countries at top
            initialCountry: (typeof initial_country !== 'undefined') ? initial_country : "mx",

            geoIpLookup: function (callback) {
                fetch("https://ipinfo.io?token=YOUR_TOKEN")
                    .then(response => response.json())
                    .then(data => callback(data.country))
                    .catch(() => callback("us"));
            },
        });

        // Listen for changes and update hidden inputs
        input.addEventListener("countrychange", function () {
            var countryData = iti.getSelectedCountryData();
            document.querySelector("#dial_code").value = '+' + countryData.dialCode;
            document.querySelector("#dial_code_iso").value = countryData.iso2;
        });
    });
}

// initialize select 2
// $('.select2').select2({
//     width: '100%', // Makes it responsive
//     placeholder: "Select an option", // Placeholder text
//     allowClear: true // Adds a clear button
// });

$('.select2').each(function () {
    $(this).select2({
        dropdownParent: $(this).parent(),
    });
});

function formatDate(dateString) {
    var date = new Date(dateString);
    var options = { day: '2-digit', month: 'short', year: 'numeric', hour: '2-digit', minute: '2-digit' };
    return date.toLocaleString('en-US', options);
}

flatpickr("#date", {
    mode: "range",                // Enable range selection
    dateFormat: "d-m-Y",          // Format dates
    // maxDate: "today",             // Start from today
    locale: {
        rangeSeparator: " to ",   // Separator between dates
    }
});

// data-table initialization
/*if($('.dataTable').length > 0 && !$.fn.DataTable.isDataTable('.dataTable')) {
    $('.dataTable').DataTable({
        searching: false,
        paging: false,
        ordering: false,
        info: false,
        "language": {
            "emptyTable": "No records found"
        },
        "fnDrawCallback": function( oSettings ) {
            if (oSettings.fnRecordsTotal() === 0) {
            } else {
                $("tfoot td").show();
            }
        }
    });
}*/

//update status of deal with sweet alert confirmation
function confirmUpdate() {
    swal.fire({
        title: window.translation.areYouSure,
        text: window.translation.updateQuestion,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: window.translation.yesUpdate
    }).then((result) => {
        if (result.isConfirmed) {
            submitForm();
        }
    });
}


//fetch deals count
function updateRecentDealsCount() {
    let routeUrl = $('meta[name="my-route"]').attr('content');
    fetch(routeUrl)
        .then(response => response.json())
        .then(data => {
            function updateBadge(selector, count) {
                let badge = $(selector);
                if (count > 0) {
                    if (badge.length === 0) {
                        $(selector).parent().append(`<span id="${selector.replace('#', '')}" class="count-menu">${count}</span>`);
                    } else {
                        badge.text(count).show();
                    }
                } else {
                    badge.hide();
                }
            }
            updateBadge('#recent-hold-deals-badge', data.newHoldDealsCount);
            updateBadge('#recent-disputed-deals-badge', data.newDisputedDealsCount);
            updateBadge('#recent-canceled-deals-badge', data.newCancelDealsCount);

        })
        .catch(error => console.error("Error fetching recent deal counts:", error));

}
document.addEventListener("DOMContentLoaded", updateRecentDealsCount);

$(".notification-dropdown").click(function () {
    $(".notifications-list").toggle();
    $(".paymentNotifications-list").hide();
});

$(".paymentNotification-dropdown").click(function () {
    $(".paymentNotifications-list").toggle();
    $(".notifications-list").hide();
});


Fancybox.bind("[data-fancybox]", {
    Toolbar: true,
    Thumbs: true,
    loop: true,
});
$(document).on('click', '.send-message-btn', function () {

    const name = $(this).data('name');
    const dialCode = $(this).data('dialcode');
    const mobileNumber = $(this).data('mobilenumber');
    const customerId = $(this).data('customerid');
    const fullNumber = dialCode + mobileNumber;
    // Set modal display info
    $('#sendMessage #recipient-name').text(name);
    $('#sendMessage #recipient-number').text(fullNumber);
    //set hidden input values
    $('#sendMessage #dial_code').val(dialCode);
    $('#sendMessage #mobile_number').val(mobileNumber);
    //set form action dynamically
    //$('#sendMessage form').attr('action', '/admin/send-message/');

});