<?php
return [
    'home' => [
        'welcome' => 'Welcome to our website!',
        'slider_heading' => 'Your Digital Handshake for Every Deal',
        'sub_heading'    => 'Deals You Can\'t Refuse',
        'description'    => 'Sale y Vale is your digital handshake for secure, informal transactions. Create, confirm, and document deals between two parties with proof of payment—no confusion, just clear evidence and trusted transfers.',
    ],
    'about_us' => [
        'title'       => 'Building Trust in Every Deal',
        'sub_title' => 'About Us',
        'description1' => 'Sale y Vale is a smart deal-recording app built to make every transaction safer, clearer, and more reliable. Whether you’re sending or receiving money, it creates a secure digital record that both parties can trust.',
        'description2' => 'With transparent handling of funds and evidence of every deal, we remove doubts and disputes. Our mission is simple—making trust easier, one deal at a time. ',
        'read_more'   => 'READ MORE',
    ],
    'app_download' => [
        'title' => 'HOW IT WORKS',
        'sub_title' => 'App Working',
        'grid1' => [
            'title' => 'Sign Up & Connect',
            'description' => 'Download the app, sign up with your phone number, and connect directly with the person you’re dealing with.

'
        ],
        'grid2' => [
            'title' => 'Invite for the deal',
            'description' => 'Either party can start a deal by entering phone number, description, and amount, then send a request.

'
        ],
        'grid3' => [
            'title' => 'Transfer Payment and Upload Proof',
            'description' => 'Transfer Payment and Upload the payment proof.  

'
        ],
    ],
    'app_promo' => [
        'title' => 'Get Started Today',
        'description' => 'Experience safer, clearer, and smarter transactions with Sale y Vale. Record deals, secure your payments, and build trust with every transaction. Download the app now on your android or iOS device and join a growing community that values transparency.'

    ],
    'faq' => [
        'title' => 'FAQs (Frequently Asked Questions)',
        'subtitle' => 'We’ve Got Answers',
        'faqs1' =>
        [
            'question' => 'What is Sale y Vale',
            'answer' => 'Sale y Vale is a deal-recording app that provides digital proof of agreements and securely manages payments between two parties. ',
        ],
        'faqs2' =>   [
            'question' => 'Does the app handle payments directly?',
            'answer' => 'No. Payments are made outside the app through your preferred method, but the proof and process are tracked inside Sale y Vale.',
        ],
        'faqs3' =>   [
            'question' => 'How does Sale y Vale ensure trust?',
            'answer' => 'The app records deal details, requires payment proof, and releases funds only after confirmation, ensuring transparency for both parties.',
        ],
        'faqs4' =>    [
            'question' => 'Who can create a deal? ',
            'answer' => 'Either party can start a deal—there’s no fixed buyer or seller role. It works as Party A and Party B',
        ],
        'faqs5' =>   [
            'question' => 'Is there a commission fee? ',
            'answer' => 'Yes. Sale y Vale charges a small percentage, deducted from the payment before releasing the balance to the recipient.',
        ],
        'faqs6' =>    [
            'question' => 'On which platforms is Sale y Vale available?',
            'answer' => 'The app is available for download on both Android (Google Play Store) and iOS (Apple App Store).',
        ],
    ],
    'links'
    => [
        'navigation' => [
            'heading' => 'Navigation',
            'labels' => [
                'home' => 'Home',
                'about_us' => 'About Us',
                'download_app' => 'Download App',
                'contact_us' => 'Contact Us',
                'terms_conditions' => 'Terms & Conditions',
                'privacy_policy' => 'Privacy Policy'
            ],
        ],
        'get_in_touch' => 'Get in Touch',
    ],
    'contact_us' =>
    [
        'title' => 'We want to hear from you. let’s us know how we can help!',
        'label' => [
            'name' => 'Full Name',
            'phone' => 'Phone Number',
            'message' => 'Message',
            'email' => 'Email Address',
        ],
        'send_message' => 'Send Message'
    ],
    'all_rights_reserved' => 'All rights reserved',
    'terms_conditions' =>
    [
        'description_line1' => 'Welcome to our website, By using our app and services, you agree to the following terms and conditions. Please read them carefully to understand your rights, responsibilities, and how we operate.',
        'description_line2' => 'By accessing or using our platform, you acknowledge that you have read, understood, and agreed to be bound by these terms.',
        'use_of_our_platform' => [
            'title' => 'Use of Our Platform',
            'description' => 'You may use our app and services only for lawful purposes and in accordance with these Terms. You agree not to:',
            'bullet1' => 'Violate any applicable laws or regulations.',
            'bullet2' => 'Post or share content that is harmful, abusive, offensive, misleading, or violates the rights of others.',
            'bullet1' => 'Attempt to access restricted parts of the platform or interfere with its operation.',
        ],
        'account_registration' => [
            'title' => 'Account Registration',
            'description' => 'The information we collect helps us:',
            'bullet1' => 'To access certain features, you may need to create an account.',
            'bullet2' => 'You are responsible for providing accurate information and keeping your account credentials confidential.',
            'bullet1' => 'You agree to notify us immediately if you suspect unauthorized use of your account.',
        ],
        'deals_coupons_offers' => [
            'title' => 'Deals, Coupons & Offers',
            'bullet1' => 'We provide access to deals, discounts, and coupons from third-party brands. These offers are subject to the terms and conditions set by the respective brands or providers.',
            'bullet2' => 'We do not guarantee the availability, accuracy, or validity of any deal or coupon.',
            'bullet3' => 'We reserve the right to remove, modify, or update deals without prior notice.',
        ],
        'user_content' => [
            'title' => 'User Content',
            'bullet1' => 'If you share reviews, feedback, or other content, you grant us a non-exclusive, royalty-free, worldwide license to use, display, and distribute that content as part of the platform.',
            'bullet2' => 'You are solely responsible for the content you share and agree not to post anything that infringes intellectual property rights, privacy rights, or any applicable law.',
        ],
        'intellectual_property' => [
            'title' => 'Intellectual Property',
            'bullet1' => 'All content on the platform, including text, graphics, logos, designs, and images, is owned or licensed by us and protected by intellectual property laws.',
            'bullet2' => 'You may not reproduce, distribute, or exploit our content without written permission.',
        ],
        'third_party_links' => [
            'title' => 'Third-Party Links',
            'bullet1' => 'Our platform may contain links to external websites or services.',
            'bullet2' => 'We do not endorse or take responsibility for their content, privacy practices, or terms.',
            'bullet3' => 'Users access such links at their own risk.',
        ],
        'limitation_of_liability' => [
            'title' => 'Limitation of Liability',
            'bullet1' => 'We strive to ensure the smooth operation of our platform, but we cannot guarantee it will always be error-free, uninterrupted, or secure.',
            'bullet2' => 'We are not responsible for any loss, damages, or inconvenience resulting from your use of the app or reliance on deals and offers.',
            'bullet3' => 'Our liability is limited to the maximum extent permitted by applicable law.',
        ],
        'termination' => [
            'title' => 'Termination',
            'description_line1' => 'We reserve the right to suspend or terminate your account and access to the platform if you violate these Terms or engage in behavior that harms our community or reputation.',
        ],
        'changes_to_terms' => [
            'title' => 'Changes to These Terms',
            'description_line1' => 'We may update or revise these Terms from time to time to reflect changes in our services or legal requirements.',
            'description_line2' => 'The updated version will be posted on this page with a new effective date.',
            'description_line3' => 'It is your responsibility to review these Terms regularly to stay informed.',
        ],
        'governing_law' => [
            'title' => 'Governing Law',
            'description_line1' => 'These Terms are governed by the laws of [Insert jurisdiction], without regard to conflict of law principles.',
            'description_line2' => 'Any disputes will be resolved in the appropriate courts within that jurisdiction.',
        ],
        'contact_us' => [
            'title' => 'Contact Us',
            'description_line1' => 'If you have questions, concerns, or suggestions about these Terms, please contact us.',
        ],

    ],
    'privacy_policy' => [
        'description_line1' => 'At our website , we value your trust and are committed to protecting your personal information. This Privacy Policy explains how we collect, use, and safeguard your data when you use our app and services to discover deals, discounts, and coupons from top brands.',
        'description_line2' => 'By using our platform, you agree to the terms outlined in this policy.',
        'information_we_collect' => [
            'title' => 'Information We Collect',
            'description_line1' => 'We collect information to provide you with a personalized, seamless shopping experience. This may include:',
            'bullet1' => 'Personal Information: Such as your name, email address, phone number, and location (if provided by you voluntarily).',
            'bullet2' => 'Device Information: Information about your device, browser, and operating system for performance optimization.',
            'bullet3' => 'Usage Data: Interaction details such as pages visited, time spent on the app, and click patterns to help us improve your experience.',
            'bullet4' => 'Cookies & Tracking Technologies: We use cookies to remember your preferences and provide relevant deals and offers.',
        ],
        'how_we_use_information' => [
            'title' => 'How We Use Your Information',
            'description_line1' => 'The information we collect helps us:',
            'bullet1' => 'Provide and personalize deals, coupons, and discounts based on your interests.',
            'bullet2' => 'Improve our services and app functionality.',
            'bullet3' => 'Communicate important updates, offers, and promotions.',
            'bullet4' => 'Detect and prevent fraudulent activity and enhance app security.',
            'bullet5' => 'Analyze user trends to enhance your shopping experience.',
        ],
        'sharing_information' => [
            'title' => 'Sharing Your Information',
            'description_line1' => 'We respect your privacy and will never sell or rent your personal information to third parties. However, we may share your data in the following cases:',
            'bullet1' => 'With trusted partners and service providers: who assist us in delivering services (e.g., analytics, customer support, or advertising) under strict confidentiality agreements.',
            'bullet2' => 'For legal purposes: such as complying with laws, enforcing our terms, or protecting the safety and rights of users.',
        ],
        'data_security' => [
            'title' => 'Data Security',
            'description_line1' => 'We implement industry-standard security measures to protect your personal information from unauthorized access, alteration, disclosure, or destruction.',
            'description_line2' => 'However, no online system is 100% secure, so we encourage you to use strong passwords and update them regularly.',
        ],
        'your_choices' => [
            'title' => 'Your Choices',
            'description_line1' => 'You have control over your personal information. You can:',
            'bullet1' => 'Opt-out of marketing communications by following the unsubscribe link in emails.',
            'bullet2' => 'Adjust your device or browser settings to limit cookies.',
            'bullet3' => 'Contact us to update or delete your personal data from our system.',
        ],
        'childrens_privacy' => [
            'title' => 'Children’s Privacy',
            'description_line1' => 'Our services are not intended for children under the age of 13. We do not knowingly collect personal data from minors.',
            'description_line2' => 'If you believe we have inadvertently collected such data, please contact us to have it removed.',
        ],
        'changes_to_policy' => [
            'title' => 'Changes to This Policy',
            'description_line1' => 'We may update this Privacy Policy from time to time. Any changes will be posted on this page with an updated effective date.',
            'description_line2' => 'We encourage you to review this policy regularly to stay informed about how we protect your information.',
        ],
        'contact_us' => [
            'title' => 'Contact Us',
            'description_line1' => 'If you have any questions, concerns, or requests regarding your privacy, feel free to contact us at:',
            'description_line2' => 'Email: info@saleyyale.com',
        ],
    ],
    'contact_form' => [
        'sending'       => 'Please wait while we send your message.',
        'message_sent'  => 'Message Sent',
        'something_wrong' => 'Something went wrong',
        'try_again'     => 'Please try again later',
        'server_error'  => 'Server Error',
        'please_wait' => 'Please wait while we send your message.',

    ]
];
