<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DealModel>
 */
class DealModelFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'deal_title' => $this->faker->sentence(3),
            'deal_type' => $this->faker->randomElement(['buy','sell']),
            'deal_amount' => $this->faker->randomFloat(2,100,10000),
            'deal_status' => $this->faker->randomElement(['pending','accepted','transit','completed']),
            'from_customer_id' => \App\Models\CustomerModel::factory(),
            'to_customer_id' => \App\Models\CustomerModel::factory(),
            'created_at' => now(),
            'status_datetime' => now(),
            'updated_at' => now(),
        ];
    }
}
