<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\CustomerModel>
 */
class CustomerModelFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $countrydialcodes = [
            ['iso' => 'US', 'dial_code' => '+1'],
            ['iso' => 'IN', 'dial_code' => '+91'],
            ['iso' => 'AU', 'dial_code' => '+61'],
            ['iso' => 'CA', 'dial_code' => '+1'],
            ['iso' => 'DE', 'dial_code' => '+49'],
            ['iso' => 'FR', 'dial_code' => '+33'],
            ['iso' => 'BR', 'dial_code' => '+55'],
            ['iso' => 'JP', 'dial_code' => '+81'],
            ['iso' => 'CN', 'dial_code' => '+86'],
        ];
        $randomcountry = $this->faker->randomElement($countrydialcodes);
        return [
            'full_name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail,
            'mobile_number' => $this->faker->numerify('##########'),
            'dial_code' => $randomcountry['dial_code'],
            'dial_code_iso' => $randomcountry['iso'],
            'address' => $this->faker->address(),
            'password' => Hash::make('123456'),
        ]; 
        
    }
}
