<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class profileModel extends Model
{
    use HasFactory;
    protected $table = 'admins';
    protected $fillable =
    [
        'name',
        'email',
        'mobile_number',
        'dial_code',
        'dial_code_iso',
        'email_verified_at',
        'password',
        'remember_token',
        'created_at',
        'updated_at',
        'image'
    ];

    public function profileValidation($inputs = [], $id = null)
    {
        $rules = [
            'name' => 'required|string|max:30|min:3',
            'mobile_number' => 'required',
            'email' => 'required|email|unique:admins,email',
            'dial_code' => 'required',
            'dial_code_iso' => 'required',
            'image' => 'nullable|image|mimes:jpg,jpeg,webp,png,gif|max:2048',
        ];

        if ($id) {
            $rules['email'] = 'required|email|unique:customers,email,' . $id;
            $rules['password'] = 'nullable';
        }
        return validator($inputs, $rules);
    }

    //mobile number exist
    public function existMobileNumber($dial_code, $dial_code_iso, $mobile_number, $skip_id = null)
    {
        $result = $this
            ->where('dial_code', $dial_code)
            ->where('dial_code_iso', $dial_code_iso)
            ->where('mobile_number', $mobile_number);

        //edit case
        if ($skip_id) {
            $result = $result->where('id', '!=', $skip_id);
        }

        return $result->first();
    }

    public function changePasswordValidation($inputs = [], $id = null)
    {
        $rules = [
            'old_password' => 'required',
            'new_password' => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$/',
            'min:8',
            'confirm_password' => 'required',



        ];

        $message =   [
            'new_password.regex' => 'Password must be atleast 8 characters long and include at least one uppercase letter, one lowercase letter, one number, and one special character.'
        ];




        return validator($inputs, $rules, $message);
    }
}
