<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DealDocumentRejection extends Model
{
    use HasFactory;
    protected $table = "deal_documnet_rejections";
    protected $fillable = [
        'deal_id',
        'document_type',
        'rejected_by',
        'reason'
    ];
    public function deal()
    {
        return $this->belongsTo(DealModel::class);
    }
    public function admin()
    {
        return $this->belongsTo(AdminModel::class, 'rejected_by');
    }
}
