<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CustomerModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use ArrayObject;
use Illuminate\Support\Facades\DB;
use App\Mail\CustomerVerificationMail;
use App\Mail\ResetPasswordMail;
use App\Models\PasswordResetAttempts;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;
use Kreait\Firebase\Exception\Auth\FailedToVerifyToken;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\Auth as CustomerAuth;
use Illuminate\Support\Facades\Log;


use stdClass;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        $data = new ArrayObject();
        try {
            DB::beginTransaction();

            $validation = (new CustomerModel())->signupApiValidation($request->all());

            if ($validation->fails()) {
                return apiResponse(400, $validation->errors(), $data, true);
            }

            // Check if mobile number exists
            $mobileExist = CustomerModel::where('dial_code', $request->dial_code)
                ->where('dial_code_iso', $request->dial_code_iso)
                ->where('mobile_number', $request->mobile_number)->first();
            //dd($mobileExist);
            if (!empty($mobileExist) && $mobileExist->is_number_verified == 1 && $mobileExist->is_invited == 0) {
                return apiResponse(400, __('message.mobile_exist'));
            } elseif (!empty($mobileExist) && $mobileExist->is_number_verified == 0 && $mobileExist->is_invited == 0) {
                $data = [
                    'is_number_verified' => 0,

                ];
                return apiResponse(200, __('message.mobile_not_verified'), $data);
            }
            // Check if email exists
            /*$emailExist = CustomerModel::where('email', $request->email)->first();
            if (!empty($emailExist) && $emailExist->is_number_verified == 1) {
                return apiResponse(400, __('message.email_exist'));
            } elseif (!empty($emailExist) && $emailExist->is_number_verified == 0) {
                $customer_identifier = Crypt::encryptString($emailExist->email);
                $data = [
                    'is_number_verified' => 0,
                    'customer_identifier' => $customer_identifier,
                ];
                return apiResponse(200, __('message.mobile_not_verified'), $data);
            }*/

            // Validate mobile number
            if (!isValidNumber($request->dial_code, $request->dial_code_iso, $request->mobile_number)) {
                return apiResponse(400, __('message.mobile_number_invalid'), $data);
            }

            // Generate OTP
            //$email_otp = rand(111111, 999999);
            $idFrontSide = null;
            $idBackSide = null;
            $image =  uploadDefaultImage(CUSTOMER_PATH);
            if ($request->hasFile('id_front_side') && $request->hasFile('id_back_side')) {
                // Upload ID images using helper
                $idFrontSide = uploadFile('id_front_side', CUSTOMER_PATH);
                $idBackSide  = uploadFile('id_back_side', CUSTOMER_PATH);
            }

            //if exist mobile customer is invited then update rest or create new
            if ($mobileExist && $mobileExist->is_invited) {
                Log::info("updated user: yes");
                $mobileExist->update([
                    'full_name' => $request['full_name'],
                    'email' => null,
                    'address' => $request['address'],
                    'password' => Hash::make($request['password']),
                    'status'    => ACTIVE,
                    'is_invited' => false,
                    'image' => $image,
                    'terms_conditions' => $request['terms_conditions'],
                    'id_front_side'    => $idFrontSide,
                    'id_back_side'     => $idBackSide,
                    'language_code' => $request->language_code

                ]);
                $customer = $mobileExist;
            } else {
                Log::info("updated user : no");
                // Save customer data
                $customer = (new CustomerModel())->create([
                    'full_name' => $request['full_name'],
                    'dial_code' => $request['dial_code'],
                    'dial_code_iso' => $request['dial_code_iso'],
                    'mobile_number' => $request['mobile_number'],
                    'email' => null,
                    'address' => $request['address'],
                    'password' => Hash::make($request['password']),
                    'status' => 'active',
                    //'email_otp' => $email_otp,
                    'image' => $image,
                    'terms_conditions' => $request['terms_conditions'],
                    'id_front_side'    => $idFrontSide,
                    'id_back_side'     => $idBackSide,
                    'language_code' => $request->language_code

                ]);
            }


            // Fetch created customer and hide sensitive fields
            $result = (new CustomerModel())
                ->find($customer->id);
            checkProfileUpdate($result);
            $data = [];
            // Send verification email
            /* try {

                Mail::to($result->email)->send(new CustomerVerificationMail($result));
            } catch (\Exception $e) {
                if (str_contains($e->getMessage(), '550')) {
                    return apiResponse(400, __('message.email_invalid'), $data);
                }
                return apiResponse(500, __('message.email_send_error'), $data);
            }*/


            DB::commit();
            return apiResponse(200, __('message.mobile_otp_send'), $data);
        } catch (\Exception $e) {
            DB::rollback();

            return getErrorResponse($e);
        }
    }
    //emal otp verify - no use
    /*public function verifyOtp(Request $request)
    {
        $result = new stdClass();
        try {

            DB::beginTransaction();
            $inputs = $request->all();

            if (!isset($request->customer_identifier) || empty($request->customer_identifier)) {
                return apiResponse(400, __('message.invalid_payload'));
            }
            try {
                $inputs['mobile_number'] = Crypt::decryptString($request->customer_identifier);
            } catch (\Illuminate\Contracts\Encryption\DecryptException $e) {
                return apiResponse(400, __('message.invalid_payload'));
            }

            //dd($inputs);
            $validation = Validator::make($inputs, [
                'email_otp' => 'required|numeric',
                'email' => 'required|exists:customers,email',
                'fcm_token' => 'required|string',


            ]);
            if ($validation->fails()) {
                return apiResponse(400, $validation->errors(), [], true);
            }




            $customer =  CustomerModel::where('email', $inputs['email'])->first();
            if (!$customer) {
                $message = __('message.email_invalid');
                return apiResponse(400, $message);
            }


            if ($customer->email_otp != $request->email_otp) {
                $message = __('message.invalid_otp');
                return apiResponse(400, $message);
            }


            CustomerModel::where('id', $customer->id)->update([
                'is_email_verified' => 1,
                'email_verified_at' => Carbon::now(),
            ]);
            $customer->fcm_token = $request->fcm_token;
            $customer->save();
            DB::commit();
            $data = [
                'auth_token' => $customer->createToken($customer->email)->plainTextToken,

            ];
            // $message = "Email verified successfully.";
            // return apiResponse(200, $message, $data);
            $message = __('message.successfully_verified');
            $message_description = __('message.verification_completed');
            return apiResponse(200, $message, $data, false, $message_description);
        } catch (FailedToVerifyToken $e) {
            $message = getErrorResponse($e);
            return apiResponse(400, $message);
        }
    }*/
    public function verifyMobileToken(Request $request)
    {

        try {
            DB::beginTransaction();
            $validation = Validator::make(
                $request->all(),
                [
                    'firebaseToken' => 'required|string',
                    'fcm_token' => 'required|string',
                    'mobile_number' => 'required|string|digits_between:6,15',
                    'dial_code' => 'required|string|regex:/^\+\d{1,4}$/'
                ]
            );

            if ($validation->fails()) {
                return apiResponse(400, $validation->errors(), [], true);
            }
            // firebase code start
            $servicePath = storage_path('firebase-service.json');
            $factory = (new Factory)->withServiceAccount($servicePath);
            $auth = $factory->createAuth();
            try {
                $verifiedIdToken = $auth->verifyIdToken($request->firebaseToken);
            } catch (FailedToVerifyToken $e) {
                $message = getErrorResponse($e);
                return apiResponse(400, $message);
            }
            $uid = $verifiedIdToken->claims()->get('sub');
            $user = $auth->getUser($uid);
            //dd($user);
            $registered_customer = CustomerModel::where('dial_code', $request->dial_code)
                ->where('mobile_number', $request->mobile_number)
                ->first();
            if (!$registered_customer) {
                return apiResponse(404, __('message.customer_not_found'));
            }
            $fullMobileNumber = $registered_customer->dial_code . $registered_customer->mobile_number;

            if ($fullMobileNumber == $user->phoneNumber) {
                //Log::info('match with user : yes');
                // Now get the updated customer model instance
                $registered_customer->is_number_verified = 1;
                $registered_customer->number_verified_at = Carbon::now();
                $registered_customer->fcm_token = $request->fcm_token;
                //update country data at customer profile
                $country = DB::table('countries')->where('iso2', $registered_customer->dial_code_iso)->select('id')->first();
                if ($country) {
                    $registered_customer->country_id = $country->id;
                }
                $registered_customer->save();
                //Log::info($registered_customer);
                DB::commit();
                $data = [
                    'auth_token' => $registered_customer->createToken('auth_token')->plainTextToken,
                ];
                $message = __('message.successfully_verified');
                $message_description = __('message.verification_completed');
                return apiResponse(200, $message, $data, false, $message_description);
            } else {
                Log::info('match with user : no');
                $message = __('message.mobile_number_invalid');
                return apiResponse(400, $message);
            }

            // firebase code end
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
            // return apiResponse(500, $message, $result);
        }
    }
    //login api
    public function login(Request $request)
    {
        $result = new stdClass;
        $validation = Validator::make(
            $request->all(),
            [
                'mobile_number' => 'required|string',
                'dial_code' => 'required|string',
                'password' => 'required|string',
                'fcm_token' => 'required|string',
                'language_code' => 'required|in:en,es'
            ]
        );

        if ($validation->fails()) {
            return apiResponse(400, $validation->errors(), [], true);
        }

        $result = CustomerModel::where('mobile_number', $request->mobile_number)
            ->where('dial_code', $request->dial_code)->first();

        if (!$result || !Hash::check($request->password, $result->password)) {
            return apiResponse(400, __('message.invalid_credentials'));
        }

        //inactive customer
        /* if ($result->status == INACTIVE) {
            return apiResponse(400, __('message.account_inactive'));
        }*/


        $data = [

            'is_number_verified' => (int) $result->is_number_verified,
            //'is_email_verified' =>  $result->is_email_verified,
            'email' =>  $result->email,
        ];
        if ($result->is_number_verified == 0) {
            $message = __('message.verify_mobile');
            return apiResponse(200, $message, $data);
        }
        /* if ($result->is_email_verified == 0) {
            $otpCode = mt_rand(111111, 999999);
            $result1['email_otp'] = $otpCode;

            try {
                // send verification email
                Mail::to($result->email)->send(new CustomerVerificationMail($result1));
            } catch (\Exception $e) {
                if (str_contains($e->getMessage(), '550')) {
                    return apiResponse(400, __('message.email_invalid'), $data);
                }
                return apiResponse(500, __('message.email_send_error'), $data);
            }
            CustomerModel::where('id', $result->id)->update(['email_otp' => $otpCode]);
            $message = __('message.otp_email_sent');
            return apiResponse(200, $message, $data);
        }*/

        $result->fcm_token = $request->fcm_token;
        $result->language_code = $request->language_code;
        $result->save();

        //check exist token
        $result->tokens()->delete();
        $data = [
            //create token
            'auth_token' => $result->createToken('auth-token')->plainTextToken,
            'id' => $result->id,
            'is_number_verified' => (int) $result->is_number_verified,
            'is_profile_updated' => $result->is_profile_updated,


        ];
        return apiResponse(200, __('message.login_success'), $data, false);
    }
    public function forgotPassword(Request $request)
    {
        $result = new ArrayObject();
        try {
            DB::beginTransaction();
            $validation  = Validator::make($request->all(), [
                'dial_code_iso' => 'required|string|size:2|alpha|uppercase',
                'dial_code' => 'required|string|min:1|max:6',
                'mobile_number' => 'required|regex:/^[0-9]{6,15}$/',

            ]);

            if ($validation->fails()) {

                return apiResponse(400, $validation->errors(), [], true);
            }
            // Validate mobile number
            if (!isValidNumber($request->dial_code, $request->dial_code_iso, $request->mobile_number)) {
                return apiResponse(400, __('message.mobile_number_invalid'));
            }
            // Check if mobile number exists
            $customer = CustomerModel::where('dial_code', $request->dial_code)->where('mobile_number', $request->mobile_number)->first();
            if (!$customer) {
                return apiResponse(400, __('message.customer_not_found'));
            }
            if ($customer->is_number_verified == 0) {
                return apiResponse(400, __('message.number_not_verified'));
            }
            //check attempt record 
            $attempt = PasswordResetAttempts::where('customer_id', $customer->id)->first();

            $now = now();

            if ($attempt) {
                // record exists
                if (Carbon::parse($attempt->last_attempt_at)->diffInHours($now) < 24 && $attempt->attempt_count >= 2) {
                    return apiResponse(400, __('message.exceed_attempt_limit'), [
                        'attempt_count' => $attempt->attempt_count,
                        'last_attempt_date' => $attempt->last_attempt_at,
                    ]);
                }

                $attempt->attempt_count += 1;
                $attempt->last_attempt_at = $now;
                $attempt->save();
            } else {

                // create new record
                PasswordResetAttempts::create([
                    'customer_id' => $customer->id,
                    'attempt_count' => 1,
                    'last_attempt_at' => $now,
                ]);
            }
            DB::commit();
            return apiResponse(200, __('message.forgot_password_success'));
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
        }
    }

    public function forgotPasswordVerification(Request $request)
    {
        try {
            // firebase code start
            $servicePath = storage_path('firebase-service.json');
            $factory = (new Factory)->withServiceAccount($servicePath);
            $auth = $factory->createAuth();
            try {
                $verifiedIdToken = $auth->verifyIdToken($request->firebaseToken);
            } catch (FailedToVerifyToken $e) {
                $message = getErrorResponse($e);
                return apiResponse(400, $message);
            }
            $uid = $verifiedIdToken->claims()->get('sub');
            $user = $auth->getUser($uid);
            //dd($user);
            $registered_customer = CustomerModel::where('dial_code', $request->dial_code)->where('mobile_number', $request->mobile_number)->first();
            $fullMobileNumber = $registered_customer->dial_code . $registered_customer->mobile_number;

            if ($fullMobileNumber == $user->phoneNumber) {

                $customer =  CustomerModel::where('id', $registered_customer->id)->update([
                    'is_number_verified' => 1,
                    'number_verified_at' => Carbon::now(),
                    'fcm_token' => $request->fcm_token,
                ]);

                $message = __('message.successfully_verified');
                $message_description = __('message.verification_completed');
                return apiResponse(200, $message, [], false, $message_description);
            } else {

                $message = __('message.mobile_number_invalid');
                return apiResponse(400, $message);
            }

            // firebase code end
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
            // return apiResponse(500, $message, $result);
        }
    }
    //no use
    /*public function verifyForgotOtp(Request $request)
    {
        $result = new ArrayObject();
        try {
            DB::beginTransaction();
            $inputs = $request->all();
            if (!isset($request->customer_identifier) || empty($request->customer_identifier)) {
                return apiResponse(400, __('message.invalid_payload'));
            }
            try {
                $inputs['email'] = Crypt::decryptString($request->customer_identifier);
            } catch (\Illuminate\Contracts\Encryption\DecryptException $e) {
                return apiResponse(400, __('message.invalid_payload'));
            }


            $validation = Validator::make($inputs, [
                'forgotOtp' => 'required|numeric',
                'email' => 'required|email|min:3|max:100'
            ]);
            if ($validation->fails()) {
                return apiResponse(400, $validation->errors(), [], true);
            }

            $customer =  CustomerModel::where('email', $inputs['email'])->first();
            if (!$customer) {
                $message = __('message.email_invalid');
                return apiResponse(400, $message);
            }
            if ($customer->email_otp != $request->forgotOtp) {
                $message = __('message.invalid_otp');
                return apiResponse(400, $message);
            }

            DB::commit();
            if (!$result) {
                $message = __('message.invalid_email_or_otp');
                return apiResponse(400, $message);
            } else {
                $data = [
                    'customer_identifier' => $request->customer_identifier,
                ];
                $message = __('message.otp_verified_success');
                return apiResponse(200, $message, $data);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
        }
    }*/
    public function changeForgotPassword(Request $request)
    {
        //encrypt email
        $result = new ArrayObject();
        try {
            DB::beginTransaction();
            $inputs = $request->all();


            $validation = Validator::make(
                $request->all(),
                [
                    'dial_code_iso' => 'required|string|size:2|alpha|uppercase',
                    'dial_code' => 'required|string|min:1|max:6',
                    'mobile_number' => 'required|regex:/^[0-9]{6,15}$/',
                    'password' => [
                        'required',
                        'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$/',
                        'min:8',
                    ],
                ]
            );
            if ($validation->fails()) {

                return apiResponse(400, $validation->errors()->first());
            }
            // Validate mobile number
            if (!isValidNumber($request->dial_code, $request->dial_code_iso, $request->mobile_number)) {
                return apiResponse(400, __('message.mobile_number_invalid'));
            }
            //get data of customer
            $customer = CustomerModel::where('dial_code', $request->dial_code)->where('mobile_number', $request->mobile_number)->first();
            if (empty($customer)) {
                $message = __('message.customer_not_found');
                return apiResponse(400, $message);
            } else {
                $password = Hash::make($inputs['password']);
                $customer->update(['password' => $password]);
                DB::commit();
                $message = __('message.password_updated');
                return apiResponse(200, $message);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
        }
    }

    //resend otp - no use
    /*public function resendOtp(Request $request)
    {
        try {
            DB::beginTransaction();
            $inputs = $request->all();

            if (!isset($request->customer_identifier) || empty($request->customer_identifier)) {
                return apiResponse(400, __('message.invalid_payload'));
            }
            try {
                $inputs['email'] = Crypt::decryptString($request->customer_identifier);
            } catch (\Illuminate\Contracts\Encryption\DecryptException $e) {
                return apiResponse(400, __('message.invalid_payload'));
            }
            $result = CustomerModel::where('email', $inputs['email'])->first();
            DB::commit();
            if (!$result) {
                $message = __('message.email_invalid');
                return apiResponse(200, $message);
            }

            try {
                // Send verification email
                Mail::to($result->email)->send(new CustomerVerificationMail($result));
            } catch (\Exception $e) {
                if (str_contains($e->getMessage(), '550')) {
                    return apiResponse(400, __('message.email_invalid'), $result);
                }
                return apiResponse(500, __('message.email_send_error'), $result);
            }
            $message = __('message.otp_sent_success');
            return apiResponse(200, $message);
        } catch (\Exception $e) {
            DB::rollback();
            return getErrorResponse($e);
        }
    }*/
    //logout api
    public function logout(Request $request)
    {
        $customer = CustomerModel::find(CustomerAuth::user()?->id);
        //dd($customer);
        if ($customer) {
            $customer->update([
                'fcm_token' => null,
            ]);
            $customer->tokens()->delete();
            return apiResponse(200, __('message.logout_success'));
        }
        return apiResponse(400, __('message.user_not_authenticated'));
    }
    public function test(Request $request)
    {
        $fcm = $request->fcm;
        $lang = 'es';
        $title = $lang === 'en' ?  'hello' : 'hola 11';
        $message = $lang === 'en' ?  'how are you' : '¿Cómo estás? 22';

        // $title = 'hola';
        // $message = '¿Cómo estás?';

        fcm_notifications($title, $message, $fcm, $image = null);
    }
}
