<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DealDocumentRejection;
use App\Models\DealModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class DealDocumentController extends Controller
{
    public function updateShippingDocumentStatus(Request $request, $dealId)
    {
        $validation = Validator::make($request->all(), [
            'shipping_proof_statuses' => 'required|in:accepted,rejected',
            'shipping_tarea' => 'nullable|string'

        ]);
        if ($validation->fails()) {
            return jsonResponse(false, 400, $validation->errors());
        }
        $deal = DealModel::findOrFail($dealId);
        $customerDetails = getBuyerSellerDetails($deal);
        if (!$customerDetails) {
            return jsonResponse(false, 400, __('message.invalid_deal_data'));
            //return apiResponse(400, "Invalid Deal Data");
        }

        $buyer = $customerDetails[BUYER] ?? null;
        $seller = $customerDetails[SELLER] ?? null;
        $deletedMsg = null;
        $is_updation_by_admin = 1;
        $message = null;
        try {
            DB::beginTransaction();
            //check if one customer deleted then abort the deal
            if ($buyer->deleted_at) {
                $deletedMsg = __('message.buyer_deleted');
            } elseif ($seller->deleted_at) {
                $deletedMsg = __('message.seller_deleted');
            }
            if ($deletedMsg) {
                return jsonResponse(false, 207, $deletedMsg);
            }

            if ($request->shipping_proof_statuses == REJECTED) {
                DealDocumentRejection::create([
                    'deal_id' => $dealId,
                    'document_type' => 'shipping',
                    'rejected_by' => auth()->id(),
                    'reason' => $request->shipping_tarea,
                ]);
                $message = __('message.document_rejected_successfully');
                //send notification in the case of rejection only 
                //send notification to that customer who submit the document
                $deal->shipping_status = 'rejected';
                $nType = 'document_rejected';
                $receiverId = $seller->id;
                $nTitle = "Document Rejected";
                $nTitleEs = "Documento rechazado";
                $nMessage = "Your Shipping Document has been rejected. Please reupload it.";
                $nMessageEs = "Su documento de envío ha sido rechazado. Por favor, vuelva a subirlo.";
                saveNotification($receiverId, $nType, $nTitle, $nTitleEs, $nMessage, $nMessageEs, auth()->id(), $deal->deal_number, $dealId, $is_updation_by_admin);
            } elseif ($request->shipping_proof_statuses == ACCEPTED) {

                $nType = 'document_accepted';
                $nTitle = "Document Accepted";
                $nTitleEs = "Documento aceptado";
                $nMessage = "Shipping Document has been accepted.";
                $nMessageEs = "documento de envío ha sido aceptado.";
                $deal->shipping_status = ACCEPTED;
                $message = __('message.document_accepted_successfully');
                //buyer notified
                saveNotification($buyer->id, $nType, $nTitle, $nTitleEs, $nMessage, $nMessageEs, auth()->id(), $deal->deal_number, $dealId, $is_updation_by_admin);
                //seller notified
                saveNotification($seller->id, $nType, $nTitle, $nTitleEs, $nMessage, $nMessageEs, auth()->id(), $deal->deal_number, $dealId, $is_updation_by_admin);
            }
            $deal->save();
            DB::commit();
            $extra = [
                'redirect' =>  route('admin.deal.show', ['deal' => $dealId])
            ];
            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            return jsonResponse(false, 500, __('message.internal_server_error') . $e->getMessage());
        }
    }
    public function updatePaymentDocumentStatus(Request $request, $dealId)
    {
        $validation = Validator::make($request->all(), [
            'payment_proof_statuses' => 'required|in:accepted,rejected',
            'payment_tarea' => 'nullable|string'

        ]);
        if ($validation->fails()) {
            return jsonResponse(false, 400, $validation->errors());
        }
        $deal = DealModel::findOrFail($dealId);
        $customerDetails = getBuyerSellerDetails($deal);
        if (!$customerDetails) {
            return jsonResponse(false, 400, __('message.invalid_deal_data'));
            //return apiResponse(400, "Invalid Deal Data");
        }

        $buyer = $customerDetails[BUYER] ?? null;
        $seller = $customerDetails[SELLER] ?? null;
        $deletedMsg = null;
        $is_updation_by_admin = 1;
        $message = null;
        try {
            DB::beginTransaction();
            //check if one customer deleted then abort the deal
            if ($buyer->deleted_at) {
                $deletedMsg = __('message.buyer_deleted');
            } elseif ($seller->deleted_at) {
                $deletedMsg = __('message.seller_deleted');
            }
            if ($deletedMsg) {
                return jsonResponse(false, 207, $deletedMsg);
            }

            if ($request->payment_proof_statuses == REJECTED) {
                DealDocumentRejection::create([
                    'deal_id' => $dealId,
                    'document_type' => 'payment',
                    'rejected_by' => auth()->id(),
                    'reason' => $request->payment_tarea,
                ]);
                $message = __('message.document_rejected_successfully');
                //send notification in the case of rejection only 
                //send notification to that customer who submit the document
                $deal->payment_status = 'rejected';
                $nType = "document_accepted";
                $receiverId = $buyer->id;
                $nTitle = "Document Rejected";
                $nTitleEs = "Documento rechazado";
                $nMessage = "Your Payment Document has been rejected. Please reupload it.";
                $nMessageEs = "Su comprobante de pago ha sido rechazado. Por favor, vuelva a subirlo.";
                saveNotification($receiverId, $nType, $nTitle, $nTitleEs, $nMessage, $nMessageEs, auth()->id(), $deal->deal_number, $dealId, $is_updation_by_admin);
            } elseif ($request->payment_proof_statuses == ACCEPTED) {
                /*$nType = "document_rejected";
                $receiverId = $buyer->id;
                $nTitle = "Document Accepted";
                $nTitleEs = "Documento aceptado";
                $nMessage = "Your Payment Document has been accepted.";
                $nMessageEs = "Su comprobante de pago ha sido aceptado.";*/
                $deal->payment_status = ACCEPTED;
                $message = __('message.document_accepted_successfully');
            }

            $deal->save();
            DB::commit();
            $extra = [
                'redirect' =>  route('admin.deal.show', ['deal' => $dealId])
            ];
            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            return jsonResponse(false, 500, __('message.internal_server_error') . $e->getMessage());
        }
    }
}
