<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DealModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Style\Style;
use Illuminate\Support\Facades\Response;
use Box\Spout\Common\Entity\Style\CellAlignment;


class DashboardController extends Controller
{
    public function index()
    {
        // echo now();
        // die();
        $dealstatusCategories = dealStatusCategories();
        $availableYears = DealModel::selectRaw('YEAR(created_at) as year')
            ->distinct()
            ->orderBy('year', 'desc')
            ->pluck('year')
            ->toArray();

        //dd($availableYears);
        $selectedYear = !empty($availableYears) ? $availableYears[0] : date('Y');
        $earnings = DealModel::getAdminEearnings($selectedYear);
        $commisionUSD = DealModel::where('is_paid', 1)->where('currency_code', USD)->sum('admin_earnings');
        $commisionMXN = DealModel::where('is_paid', 1)->where('currency_code', MXN)->sum('admin_earnings');
        $data = [
            'dealstatusCategories' => $dealstatusCategories,
            'ongoingDeals' => DealModel::getDealstats($dealstatusCategories[ONGOING]),
            'disputedDeals' => DealModel::getDealstats($dealstatusCategories[DISPUTED]),
            'cancelDeals' => DealModel::getDealstats($dealstatusCategories[CANCEL]),
            'holdDeals' => DealModel::getHoldDeals(),
            'totalDeals' => DealModel::totalDeals(),
            'totalBuyDeals' => DealModel::totalBuyDeals(),
            'totalSellDeals' => DealModel::totalSellDeals(),
            'earningTypes' => $earnings['earningTypes'],   // months
            'usdData' => $earnings['usdData'],             // USD per month
            'mxnData' => $earnings['mxnData'],             // MXN per month
            'availableYears' => $availableYears,
            'availableYears' => $availableYears,
            'selectedYear' => $selectedYear,
            'export_option' => 1,
            'commissionMXN' => $commisionMXN,
            'commissionUSD' => $commisionUSD
        ];



        return view('admin.default.dashboard', compact('data'));
    }
    public function getEarnings(Request $request)
    {
        $title = "";
        if ($request->requestedData == 'all') {
            $earnings = DealModel::getAdminEarningsYearWise();
            $title = "All Years Earnings";
        } else {
            $selectedYear = $request->requestedData ?? date('Y');
            $earnings = DealModel::getAdminEearnings($selectedYear); // For monthly, you can adapt MXN too
            $title = $selectedYear . "'s Earnings";
        }

        return jsonResponse(true, 200, null, ['data' => $earnings, 'title' => $title]);
    }

    public function exportReport(Request $request)
    {

        //dd($selectedYear);
        $dealstatusCategories = dealStatusCategories();
        $ongoingDeals = DealModel::getDealstats($dealstatusCategories[ONGOING]);
        $disputedDeals = DealModel::getDealstats($dealstatusCategories[DISPUTED]);
        $cancelDeals = DealModel::getDealstats($dealstatusCategories[CANCEL]);
        $holdAmountlDeals = DealModel::getHoldDeals();

        $typesOfDeals = [

            ['On Going', $ongoingDeals],
            ['Disputed', $disputedDeals],
            ['Cancel', $cancelDeals],
            ['Hold Amount', $holdAmountlDeals],
        ];


        $buySellStats = [

            ['Buyer', DealModel::totalBuyDeals()],
            ['Seller', DealModel::totalSellDeals()],

        ];

        //yearly or all years wise report of earnings
        $selectedYear = ($request->selected_year) ?? date('Y');

        $title = "";
        if ($request->selected_year == 'all') {
            $earnings = DealModel::getAdminEarningsYearWise(); // returns 'earningTypes', 'usdData', 'mxnData'
            $yearWiseEarnings = [['Year', 'USD Earnings', 'MXN Earnings']];
            $title = "All Years Earnings";
        } else {
            $selectedYear = $request->selected_year ?? date('Y');
            $earnings = DealModel::getAdminEearnings($selectedYear); // returns 'earningTypes', 'usdData', 'mxnData'
            $yearWiseEarnings = [['Month', 'USD Earnings', 'MXN Earnings']];
            $title = "Year: $selectedYear Earnings";
        }

        $totalUSD = array_sum($earnings['usdData']);
        $totalMXN = array_sum($earnings['mxnData']);

        foreach ($earnings['earningTypes'] as $index => $label) {
            $yearWiseEarnings[] = [
                $label,
                number_format($earnings['usdData'][$index], 2, '.', ''),
                number_format($earnings['mxnData'][$index], 2, '.', '')
            ];
        }


        $date = Carbon::now()->format('d-m-Y');
        $fileName = "report_{$date}.xlsx";

        return response()->streamDownload(function () use ($typesOfDeals, $buySellStats, $yearWiseEarnings, $title, $earnings) {
            $writer = WriterEntityFactory::createXLSXWriter();
            $writer->openToFile('php://output');

            $headerStyle = (new Style())->setFontBold();
            $rightAlignStyle = (new Style())->setCellAlignment(CellAlignment::RIGHT);
            $leftAlignStyle = (new Style())->setCellAlignment(CellAlignment::LEFT);




            // sheet 1- deals type data
            // sheet 1- deals type data
            $writer->getCurrentSheet()->setName("Types of Deals");
            $titleRow = WriterEntityFactory::createRowFromArray([
                'Deal Category',
                'Total Deals',
                'MXN Deals',
                'USD Deals',
                'Total Amount (MXN)',
                'Total Amount (USD)'
            ], $headerStyle);
            $writer->addRow($titleRow);

            foreach ($typesOfDeals as $row) {
                $cells = [
                    WriterEntityFactory::createCell($row[0]), // category
                    WriterEntityFactory::createCell($row[1]['count']), // all deals
                    WriterEntityFactory::createCell($row[1]['mxn_deals']),
                    WriterEntityFactory::createCell($row[1]['usd_deals']),
                    WriterEntityFactory::createCell(number_format($row[1]['mxn_total'], 2), $rightAlignStyle),
                    WriterEntityFactory::createCell(number_format($row[1]['usd_total'], 2), $rightAlignStyle),
                ];
                $writer->addRow(WriterEntityFactory::createRow($cells));
            }

            // sheet 2 - buy sell statistics
            $writer->addNewSheetAndMakeItCurrent();
            $writer->getCurrentSheet()->setName("Buy & Sell Statistics");
            $titleRow = WriterEntityFactory::createRowFromArray(['Deal Type', 'Total Deals'], $headerStyle);
            $writer->addRow($titleRow);

            foreach ($buySellStats as $row) {
                $cells = [
                    WriterEntityFactory::createCell($row[0]), // Deal Category (Default alignment)
                    WriterEntityFactory::createCell($row[1]), // Total Deals (Default alignment)

                ];
                $writer->addRow(WriterEntityFactory::createRow($cells));
            }

            $writer->addRow(WriterEntityFactory::createRowFromArray(['', '']));
            $totalDealsRow = WriterEntityFactory::createRowFromArray(['Total Deals', DealModel::totalDeals()], $headerStyle);
            $writer->addRow($totalDealsRow);


            //year earnings
            $writer->addNewSheetAndMakeItCurrent();
            $writer->getCurrentSheet()->setName("Year wise Earnings");
            // Title Row (Year as Title, Second Column Empty)
            $titleRow = WriterEntityFactory::createRowFromArray([$title, ''], $headerStyle);
            $writer->addRow($titleRow);

            // Empty Row for Better Formatting
            $writer->addRow(WriterEntityFactory::createRowFromArray(['', '']));

            // Table Headers
            $writer->addRow(WriterEntityFactory::createRowFromArray($yearWiseEarnings[0], $headerStyle));

            // Data Rows
            foreach (array_slice($yearWiseEarnings, 1) as $row) {
                $cells = [
                    WriterEntityFactory::createCell($row[0], $leftAlignStyle),          // Month/Year
                    WriterEntityFactory::createCell('$' . $row[1], $rightAlignStyle),    // USD
                    WriterEntityFactory::createCell('$' . $row[2], $rightAlignStyle),    // MXN
                ];
                $writer->addRow(WriterEntityFactory::createRow($cells));
            }

            // Totals
            $totalUSD = array_sum($earnings['usdData']);
            $totalMXN = array_sum($earnings['mxnData']);
            $totalRow = WriterEntityFactory::createRowFromArray(['Total', '$' . $totalUSD, '$' . $totalMXN], $rightAlignStyle);
            $writer->addRow($totalRow);


            $writer->close();
        }, $fileName);
    }
    //get new deals count   
    public function getNewDealsCount()
    {
        $newHoldDealsCount = DealModel::where('is_hold', 1)->where('is_read', 0)->count();
        $newDisputedDealsCount = DealModel::where('deal_status', ON_DISPUTE)->where('is_read', 0)->count();
        $newCancelDealsCount = DealModel::where('deal_status', CANCEL)->where('is_read', 0)->count();

        return response()->json([
            'newHoldDealsCount' => $newHoldDealsCount,
            'newDisputedDealsCount' => $newDisputedDealsCount,
            'newCancelDealsCount' => $newCancelDealsCount,
        ]);
    }
}
