<?php

namespace App\Services;

use App\Services\SMSService;

class InviteService
{
    protected $smsService;

    public function __construct(SMSService $smsService)
    {
        $this->smsService = $smsService;
    }

    public function sendInvite($phoneNumber)
    {
        // Generate unique token
        $token = uniqid(); // Later you can store in DB if needed

        // Build invite URL
        $inviteUrl = route('invite.show', ['token' => $token]);

        // Compose message
        $downloadLink = $inviteUrl;

        // send SMS via SMSService
        $this->smsService->sendSMS($phoneNumber, $downloadLink);

        //return $inviteUrl;
    }
}
