<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class disputeDealConversationModel extends Model
{
    use HasFactory;
    protected $table = 'dispute_deal_conversations';
    protected $fillable = [
        'deal_id',
        'sender_id',
        'sender_type',
        'receiver_id',
        'receiver_type',
        'message',
        'is_read'
    ];
    public function disputeDeal()
    {
        return $this->belongsTo(DealModel::class);
    }
    public function sender()
    {
        return $this->morphTo();
    }
    //disput convo validation
    public static function disputeConversationValidation($requests)
    {
        $rules = [
            'deal_id' => 'required|exists:deals,id',
            'message' => 'required|string'
        ];
        return Validator($requests, $rules);
    }
    public function adminSender()
    {
        return $this->belongsTo(AdminModel::class, 'sender_id');
    }
}
