<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationModel extends Model
{
    use HasFactory;
    protected $table = 'notifications';
    protected $fillable =
    [
        'customer_id',
        'title',
        'title_es',
        'message',
        'message_es',
        'type',
        'is_read',
        'deal_id',
        'second_party_id',
        'deal_number',
        'is_updation_by_admin'
    ];
    public function customer()
    {
        return $this->belongsTo(CustomerModel::class, 'customer_id');
    }
}
