<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;

class AdminModel extends Authenticatable
{
    use Notifiable, HasRoles; // Allows notifications if needed

    protected $table = 'admins'; // Ensure it matches your table name

    protected $fillable = [
        'name',
        'email',
        'password',
        'mobile_number',
        'dial_code',
        'dial_code_iso',
        'image',
        'status'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $guard_name = 'admin';
    //mobile number exist
    public function existMobileNumber($dial_code, $dial_code_iso, $mobile_number, $skip_id = null)
    {
        $result = $this
            ->where('dial_code', $dial_code)
            ->where('dial_code_iso', $dial_code_iso)
            ->where('mobile_number', $mobile_number);

        //edit case
        if ($skip_id) {
            $result = $result->where('id', '!=', $skip_id);
        }

        return $result->first();
    }
}
