<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Throwable;
use Twilio\Rest\Client;

class SMSService
{
    protected $twilio;
    public function __construct()

    {
        $sid = config('services.twilio.sid');
        $token = config('services.twilio.token');
        $this->twilio = new Client($sid, $token);
    }


    public function sendSMS($phoneNumber, $downloadLink)
    {

        $to = "whatsapp:" . $phoneNumber;
        $from = config('services.twilio.whatsapp_from');
        $contentSid = "HX7830a93ef15611b16c5c297066686e95";
        try {
            //send message
            $this->twilio->messages
                ->create(
                    $to, // to
                    [
                        "from" => $from,
                        "contentSid" => $contentSid, // from Twilio console
                        "contentVariables" => json_encode([
                            "1" => $phoneNumber,          // replaces {{1}}
                            "2" => $downloadLink,  // replaces {{2}}
                        ]),
                    ]
                );
            // gateway API call here
            //Log::info("Whatsapp message sent to {$phoneNumber}");
        } catch (\Twilio\Exceptions\RestException $e) {
            if ($e->getCode() == 63112) {
                // fallback: free-form text message
                try {
                    $this->twilio->messages->create($to, [
                        "from" => $from,
                        "body" => "Hello {$phoneNumber}, here’s your download link: {$downloadLink}"
                    ]);
                } catch (\Throwable $ex) {
                    Log::error("Free-form WhatsApp failed: " . $ex->getMessage());
                }
            } else {
                return getErrorResponse($e);
            }
        } catch (\Throwable $e) {
            return getErrorResponse($e);
        }
    }
    //send note to customer
    public function sendNote($phoneNumber, $message)
    {
        try {
            $to = "whatsapp:" . $phoneNumber;
            $from = config('services.twilio.whatsapp_from');
            //send message
            $this->twilio->messages
                ->create(
                    $to, // to
                    [
                        "from" => $from,
                        "contentSid" => "HXdb2ff6ad2c8850ca7c34ecd20a8baae2",
                        "contentVariables" => json_encode([
                            "1" => $message, //admin's dynamic text
                        ]),

                    ]
                );
            // gateway API call here
            Log::info("Whatsapp message: {$message} sent to {$phoneNumber}");
        } catch (Throwable $e) {
            return getErrorResponse($e);
        }
    }
}
