<?php

namespace App\Providers;


use Illuminate\Support\ServiceProvider;
use App\Models\AdminNotificationModel;
use Illuminate\Support\Facades\Request;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        $this->app->booted(function () {
            if (!Request::is('api/*')) {
                view()->composer('*', function ($view) {
                    $notifications = AdminNotificationModel::where('is_read', 0)->where('notification_type', 'reply_by_customer')
                        ->orderBy('created_at', 'desc')
                        ->get(['id', 'deal_id', 'message', 'message_es', 'is_read']);

                    $paymentProofNotifications = AdminNotificationModel::where('is_read', 0)->whereIn('notification_type', ['payment_proof', 'disputed_deal'])
                        ->orderBy('created_at', 'desc')
                        ->get(['id', 'deal_id', 'message', 'message_es', 'is_read']);

                    $unreadMessagesCount = $notifications->count();
                    $paymentNotificationCount = $paymentProofNotifications->count();
                    $user = auth()->user();

                    $currentRole = ($user && count($user->roles) > 0) ? $user->roles[0]->name : 'Admin';
                    // Safely check for roles
                    // if ($user && method_exists($user, 'roles') && $user->roles->exists()) {
                    //     $currentRole = $user->roles->first()->name;
                    // } else {
                    //     $currentRole = 'Admin';
                    // }
                    $view->with([
                        'notifications' => $notifications,
                        'unreadCount' => $unreadMessagesCount,
                        'authUser' => $user,
                        'currentRole' => $currentRole,
                        'paymentProofNotifications' => $paymentProofNotifications,
                        'paymentNotificationCount' => $paymentNotificationCount
                    ]);
                });
            }
        });
    }
}
