<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\settingModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:deal - setting')->only(['setting', 'settingUpdate']);
        $this->middleware('permission:details manage - bank')->only(['bankDetails', 'bankDetailsUpdate']);
        $this->middleware('permission:About Us')->only(['aboutUs', 'aboutUsUpdate']);
        $this->middleware('permission:Privacy Policy')->only(['privacyPolicy', 'privacyPolicyUpdate']);
        $this->middleware('permission:Help')->only(['help', 'helpUpdate']);
        $this->middleware('permission:Terms and Conditions')->only(['termsAndConditions', 'termsAndConditionsUpdate']);
    }
    public function findSettings($settingName, $defaultValue)
    {
        $result = settingModel::where('setting_name', $settingName)
            ->first();

        return ($result) ? $result->description : $defaultValue;
    }

    public function setting()
    {
        $result = $this->findSettings('transfer_fees', 0);

        return view('admin.setting.setting', compact('result'));
    }

    public function bankDetails()
    {
        $bank = $this->findSettings('bank', 0);
        $card_number = $this->findSettings('card_number', 0);
        return view('admin.setting.bank-details', compact('bank', 'card_number'));
    }
    //bank details update
    public function bankDetailsUpdate(Request $request)
    {
        $request->merge([
            'card_number' => str_replace(' ', '', $request->card_number),
        ]);

        $validation = Validator::make($request->all(), [
            'bank' => 'required|string',
            'card_number' => 'required|digits_between:13,19'
        ]);

        if ($validation->fails()) {
            return jsonResponse(false, 400, $validation->errors());
        }
        try {
            DB::beginTransaction();
            $update = [
                'bank' => $request->bank,
                'card_number' => str_replace(' ', '', $request->card_number),
            ];
            (new settingModel())->updateSetting($update);
            DB::commit();
            $extra = ['redirect' => route('admin.setting.bankDetails')];
            $message = __('message.bank_details_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error') . $e->getMessage();
            return jsonResponse(false, 500, $message);
        }
    }

    //deal setting update
    public function settingUpdate(Request $request)
    {
        $inputs = $request->all();
        $validation = (new settingModel)->settingValidation($inputs);
        if ($validation->fails()) {
            return jsonResponse(false, 400, $validation->errors());
        }
        try {
            DB::beginTransaction();
            $update = [
                'transfer_fees' => $inputs['transfer_fees']
            ];
            (new settingModel())->updateSetting($update);
            DB::commit();
            $extra = ['redirect' => route('admin.setting')];
            $message = __('message.setting_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error') . $e->getMessage();
            return jsonResponse(false, 500, $message);
        }
    }
    //pages setting update
    public function aboutUs()
    {
        $result = (new settingModel)->getSetting(['about_us_en', 'about_us_es']);
        return view('admin.setting.about-us', compact('result'));
    }
    public function aboutUsUpdate(Request $request)
    {
        try {
            DB::beginTransaction();
            $update = [
                'about_us_en' => $request->about_us_en,
                'about_us_es' => $request->about_us_es,

            ];
            (new settingModel())->updateSetting($update);
            DB::commit();

            $extra = ['redirect' => route('admin.setting.aboutUs')];
            $message = __('message.setting_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error');
            return jsonResponse(false, 500, $message);
        }
    }

    public function privacyPolicy()
    {
        $result = (new settingModel)->getSetting(['privacy_policy_en', 'privacy_policy_es']);
        return view('admin.setting.privacy-policy', compact('result'));
    }
    public function privacyPolicyUpdate(Request $request)
    {

        try {

            DB::beginTransaction();
            $update = [
                'privacy_policy_en' => $request->privacy_policy_en,
                'privacy_policy_es' => $request->privacy_policy_es,

            ];
            (new settingModel())->updateSetting($update);
            DB::commit();

            $extra = ['redirect' => route('admin.setting.privacyPolicy')];
            $message = __('message.setting_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error');
            return jsonResponse(false, 500, $message);
        }
    }

    public function help()
    {
        $result = (new settingModel)->getSetting(['help_en', 'help_es']);
        return view('admin.setting.help', compact('result'));
    }
    public function helpUpdate(Request $request)
    {

        try {

            DB::beginTransaction();
            $update = [
                'help_en' => $request->help_en,
                'help_es' => $request->help_es,

            ];
            (new settingModel())->updateSetting($update);
            DB::commit();

            $extra = ['redirect' => route('admin.setting.help')];
            $message = __('message.setting_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error');
            return jsonResponse(false, 500, $message);
        }
    }

    public function termsAndConditions()
    {
        $result = (new settingModel)->getSetting(['terms_and_conditions_en', 'terms_and_conditions_es']);
        return view('admin.setting.terms-and-conditions', compact('result'));
    }
    public function termsAndConditionsUpdate(Request $request)
    {

        try {

            DB::beginTransaction();
            $update = [
                'terms_and_conditions_en' => $request->terms_and_conditions_en,
                'terms_and_conditions_es' => $request->terms_and_conditions_es,

            ];
            (new settingModel())->updateSetting($update);
            DB::commit();

            $extra = ['redirect' => route('admin.setting.termsAndConditions')];
            $message = __('message.setting_updated_successfully');

            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error');
            return jsonResponse(false, 500, $message);
        }
    }
    //web view : privacy policy:
    public function privacyPolicyWebView($lang)
    {

        $lang = $lang ?? 'en';
        $result =  (new settingModel)->getSetting(['privacy_policy_en', 'privacy_policy_es']);
        return view('web-views.privacy-policy', compact('result', 'lang'));
    }
    //web view : help:
    public function helpWebView($lang)
    {

        $lang = $lang ?? 'en';
        $result = (new settingModel)->getSetting(['help_en', 'help_es']);
        return view('web-views.help', compact('result', 'lang'));
    }
    //Terms and conditions view : help:
    public function termsConditionsWebView($lang)
    {

        $lang = $lang ??  'en';
        $result = (new settingModel)->getSetting(['terms_and_conditions_en', 'terms_and_conditions_es']);
        return view('web-views.terms-and-conditions', compact('result', 'lang'));
    }
    //About us view :
    public function aboutUsWebView($lang)
    {

        $lang = $lang ?? 'en';
        $result = (new settingModel)->getSetting(['about_us_en', 'about_us_es']);
        return view('web-views.about-us', compact('result', 'lang'));
    }
}
